/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.sheldon.corejava;

import java.util.Set;
import javax.ejb.MessageDriven;
import org.tomitribe.crest.api.Command;
import org.tomitribe.crest.api.Default;
import org.tomitribe.crest.api.Option;
import org.tomitribe.sheldon.api.CommandListener;
import org.tomitribe.util.Size;
import org.tomitribe.util.SizeUnit;

@MessageDriven(name="Runtime")
public class RuntimeBean
implements CommandListener {
    @Command
    public void gc() {
        Runtime.getRuntime().gc();
    }

    @Command
    public String freeMemory(@Option(value={"unit", "u"}) @Default(value="MEGABYTES") SizeUnit unit) {
        long bytes = Runtime.getRuntime().freeMemory();
        Size size = new Size(unit.convert(bytes, SizeUnit.BYTES), unit);
        return size.toString();
    }

    @Command
    public String maxMemory(@Option(value={"unit", "u"}) @Default(value="MEGABYTES") SizeUnit unit) {
        long bytes = Runtime.getRuntime().maxMemory();
        Size size = new Size(unit.convert(bytes, SizeUnit.BYTES), unit);
        return size.toString();
    }

    @Command
    public String totalMemory(@Option(value={"unit", "u"}) @Default(value="MEGABYTES") SizeUnit unit) {
        long bytes = Runtime.getRuntime().totalMemory();
        Size size = new Size(unit.convert(bytes, SizeUnit.BYTES), unit);
        return size.toString();
    }

    @Command
    public String threads() {
        StringBuilder sb = new StringBuilder();
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread thread : threads) {
            sb.append("{ id: \"" + thread.getId() + "\"").append(" name: \"" + thread.getName() + "\"").append(" state: \"" + (Object)((Object)thread.getState()) + "\"").append(" priority: \"" + thread.getPriority() + "\"").append(" group: \"" + (thread.getThreadGroup() != null ? thread.getThreadGroup().getName() : "none") + "\" }").append("\n");
        }
        return sb.toString();
    }
}

