/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.sheldon.corejava;

import java.io.File;
import javax.ejb.MessageDriven;
import org.tomitribe.crest.api.Command;
import org.tomitribe.crest.api.Option;
import org.tomitribe.crest.val.Directory;
import org.tomitribe.crest.val.Exists;
import org.tomitribe.sheldon.api.CommandListener;

@MessageDriven(name="SystemProperties")
public class SystemPropertiesBean
implements CommandListener {
    @Command
    public String home() {
        return System.getProperty("user.home");
    }

    @Command
    public String home(@Exists @Directory File file) {
        return System.setProperty("user.home", file.getAbsolutePath());
    }

    @Command
    public String user() {
        return System.getProperty("user.name");
    }

    @Command
    public String dir() {
        return System.getProperty("user.dir");
    }

    @Command
    public String dir(@Exists @Directory File file) {
        return System.setProperty("user.dir", file.getAbsolutePath());
    }

    @Command
    public String setProperty(@Option(value={"key", "k"}) String key, @Option(value={"value", "v"}) String value) {
        String valueReturn = System.setProperty(key, value);
        if (valueReturn == null) {
            return value;
        }
        return valueReturn;
    }

    @Command
    public String getProperty(@Option(value={"key", "k"}) String key) {
        return System.getProperty(key);
    }

    @Command
    public String javaVendor() {
        return System.getProperty("java.vendor");
    }

    @Command
    public String javaVendorUrl() {
        return System.getProperty("java.vendor.url");
    }

    @Command
    public String javaVersion() {
        return System.getProperty("java.version");
    }

    @Command
    public String osArch() {
        return System.getProperty("os.arch");
    }

    @Command
    public String osName() {
        return System.getProperty("os.name");
    }

    @Command
    public String osVersion() {
        return System.getProperty("os.version");
    }
}

