/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api;

import com.google.protobuf.ByteString;
import edu.iu.dsc.tws.api.JobConfig;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.api.resource.IWorker;
import edu.iu.dsc.tws.api.resource.Twister2Worker;
import edu.iu.dsc.tws.api.util.JobIDUtils;
import edu.iu.dsc.tws.api.util.KryoSerializer;
import edu.iu.dsc.tws.common.util.ReflectionUtils;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.proto.utils.ComputeResourceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class Twister2Job {
    private static final Logger LOG = Logger.getLogger(Twister2Job.class.getName());
    private static final KryoSerializer KRYO_SERIALIZER = new KryoSerializer();
    private String jobName;
    private String jobID;
    private String userName;
    private String workerClass;
    private String driverClass;
    private ArrayList<JobAPI.ComputeResource> computeResources = new ArrayList();
    private JobConfig config;

    private Twister2Job() {
    }

    public JobAPI.Job serialize() {
        this.checkJobParameters();
        this.updateIndexesForComputeResources();
        JobAPI.Job.Builder jobBuilder = JobAPI.Job.newBuilder();
        JobAPI.Config.Builder configBuilder = JobAPI.Config.newBuilder();
        this.config.forEach((key, value) -> {
            byte[] objectByte = KRYO_SERIALIZER.serialize(value);
            configBuilder.putConfigByteMap(key, ByteString.copyFrom((byte[])objectByte));
        });
        jobBuilder.setConfig(configBuilder);
        jobBuilder.setJobName(this.jobName);
        if (this.jobID == null) {
            this.jobID = JobIDUtils.generateJobID((String)this.jobName, (String)this.userName);
        }
        jobBuilder.setJobId(this.jobID);
        jobBuilder.setWorkerClassName(this.workerClass);
        if (this.driverClass != null) {
            jobBuilder.setDriverClassName(this.driverClass);
        }
        jobBuilder.setNumberOfWorkers(this.countNumberOfWorkers());
        for (JobAPI.ComputeResource computeResource : this.computeResources) {
            jobBuilder.addComputeResource(computeResource);
        }
        return jobBuilder.build();
    }

    private void updateIndexesForComputeResources() {
        int scalableCount = this.countScalableComputeResources();
        if (scalableCount > 1) {
            throw new RuntimeException("There can be at most one scalabe ComputeResource in a job. " + scalableCount + " scalabe ComputeResource requested. Aborting submission. +++++++");
        }
        if (scalableCount == 0) {
            return;
        }
        if (this.computeResources.get(this.computeResources.size() - 1).getScalable()) {
            return;
        }
        int scalableIndex = this.indexOfFirstScalableComputeResource();
        JobAPI.ComputeResource scalableComputeResource = this.computeResources.remove(scalableIndex);
        this.computeResources.add(scalableComputeResource);
        for (int i = scalableIndex; i < this.computeResources.size(); ++i) {
            JobAPI.ComputeResource updatedCR = ComputeResourceUtils.updateComputeResourceIndex((int)i, (JobAPI.ComputeResource)this.computeResources.get(i));
            this.computeResources.set(i, updatedCR);
        }
    }

    private int indexOfFirstScalableComputeResource() {
        int index = 0;
        for (JobAPI.ComputeResource computeResource : this.computeResources) {
            if (computeResource.getScalable()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int countScalableComputeResources() {
        int counter = 0;
        for (JobAPI.ComputeResource computeResource : this.computeResources) {
            if (!computeResource.getScalable()) continue;
            ++counter;
        }
        return counter;
    }

    private void checkJobParameters() {
        if (this.jobName == null) {
            throw new RuntimeException("Job jobName is null. You have to provide a unique jobName");
        }
        if (this.workerClass == null) {
            throw new RuntimeException("workerClass is null. A worker class has to be provided.");
        }
        if (this.computeResources.size() == 0) {
            throw new RuntimeException("No ComputeResource is provided.");
        }
        if (this.countNumberOfWorkers() == 0) {
            throw new RuntimeException("0 worker instances requested.");
        }
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setJobID(String id) {
        this.jobID = id;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getWorkerClass() {
        return this.workerClass;
    }

    public ArrayList<JobAPI.ComputeResource> getComputeResources() {
        return this.computeResources;
    }

    public int getNumberOfWorkers() {
        return this.countNumberOfWorkers();
    }

    public JobConfig getConfig() {
        return this.config;
    }

    private int countNumberOfWorkers() {
        int totalWorkers = 0;
        for (JobAPI.ComputeResource computeResource : this.computeResources) {
            totalWorkers += computeResource.getInstances() * computeResource.getWorkersPerPod();
        }
        return totalWorkers;
    }

    public static Twister2Job loadTwister2Job(Config config, JobConfig jobConfig) {
        return Twister2Job.newBuilder().setJobName(Context.jobName((Config)config)).setWorkerClass(SchedulerContext.workerClass((Config)config)).setDriverClass(SchedulerContext.driverClass((Config)config)).loadComputeResources(config).setConfig(jobConfig).build();
    }

    public static Twister2JobBuilder newBuilder() {
        return new Twister2JobBuilder();
    }

    public static final class Twister2JobBuilder {
        private Twister2Job twister2Job = new Twister2Job();
        private int computeIndexCounter = 0;

        private Twister2JobBuilder() {
        }

        public Twister2JobBuilder setJobName(String name) {
            this.twister2Job.jobName = name;
            return this;
        }

        public Twister2JobBuilder setJobID(String id) {
            this.twister2Job.jobID = id;
            return this;
        }

        public Twister2JobBuilder setWorkerClass(String workerClass) {
            try {
                Object object = ReflectionUtils.newInstance((String)workerClass);
                if (object instanceof IWorker || object instanceof Twister2Worker) {
                    this.twister2Job.workerClass = workerClass;
                    return this;
                }
                throw new Twister2RuntimeException(String.format("Worker class [%s] is neither an instance of IWorker nor Twister2Worker interfaces.", workerClass));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOG.severe(String.format("failed to load the worker class %s", workerClass));
                throw new RuntimeException(e);
            }
        }

        public Twister2JobBuilder setDriverClass(String driverClass) {
            this.twister2Job.driverClass = driverClass;
            return this;
        }

        public Twister2JobBuilder setWorkerClass(Class workerClass) {
            return this.setWorkerClass(workerClass.getCanonicalName());
        }

        public Twister2JobBuilder addComputeResource(double cpu, int ramMegaBytes, int instances) {
            this.addComputeResource(cpu, ramMegaBytes, 0.0, instances, false, 1);
            return this;
        }

        public Twister2JobBuilder addComputeResource(double cpu, int ramMegaBytes, int instances, boolean scalable) {
            this.addComputeResource(cpu, ramMegaBytes, 0.0, instances, scalable, 1);
            return this;
        }

        public Twister2JobBuilder addComputeResource(double cpu, int ramMegaBytes, double diskGigaBytes, int instances) {
            this.addComputeResource(cpu, ramMegaBytes, diskGigaBytes, instances, false, 1);
            return this;
        }

        public Twister2JobBuilder addComputeResource(double cpu, int ramMegaBytes, double diskGigaBytes, int instances, boolean scalabe) {
            this.addComputeResource(cpu, ramMegaBytes, diskGigaBytes, instances, scalabe, 1);
            return this;
        }

        public Twister2JobBuilder addComputeResource(double cpu, int ramMegaBytes, double diskGigaBytes, int instances, int workersPerPod) {
            this.addComputeResource(cpu, ramMegaBytes, diskGigaBytes, instances, false, workersPerPod);
            return this;
        }

        public Twister2JobBuilder addComputeResource(double cpu, int ramMegaBytes, double diskGigaBytes, int instances, boolean scalable, int workersPerPod) {
            JobAPI.ComputeResource computeResource = JobAPI.ComputeResource.newBuilder().setCpu(cpu).setRamMegaBytes(ramMegaBytes).setDiskGigaBytes(diskGigaBytes).setInstances(instances).setScalable(scalable).setWorkersPerPod(workersPerPod).setIndex(this.computeIndexCounter++).build();
            this.twister2Job.computeResources.add(computeResource);
            return this;
        }

        private Twister2JobBuilder loadComputeResources(Config config) {
            List list = (List)config.get("twister2.resource.worker.compute.resources");
            for (Map computeResource : list) {
                double cpu = (Double)computeResource.get("cpu");
                int ram = (Integer)computeResource.get("ram");
                double disk = (Double)computeResource.get("disk");
                int instances = (Integer)computeResource.get("instances");
                boolean scalable = false;
                if (computeResource.get("scalable") != null) {
                    scalable = (Boolean)computeResource.get("scalable");
                }
                int workersPerPod = 1;
                if (computeResource.get("workersPerPod") != null) {
                    workersPerPod = (Integer)computeResource.get("workersPerPod");
                }
                this.addComputeResource(cpu, ram, disk, instances, scalable, workersPerPod);
            }
            return this;
        }

        public Twister2JobBuilder setConfig(JobConfig config) {
            this.twister2Job.config = config;
            return this;
        }

        public Twister2Job build() {
            if (this.twister2Job.config == null) {
                this.twister2Job.config = new JobConfig();
            }
            return this.twister2Job;
        }
    }
}

