/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.util;

import edu.iu.dsc.tws.api.config.Config;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public final class CommonThreadPool {
    private static final String COMMON_POOL_THREADS = "twister2.common.thread.pool.threads";
    private static final String COMMON_POOL_KEEP_ALIVE = "twister2.common.thread.pool.keepalive";
    private static final Logger LOG = Logger.getLogger(CommonThreadPool.class.getName());
    private static volatile CommonThreadPool commonThreadPool;
    private ExecutorService executorService;
    private int threads;

    public static synchronized void init(Config config) {
        int threads = config.getIntegerValue(COMMON_POOL_THREADS, 1);
        int keepAlive = config.getIntegerValue(COMMON_POOL_KEEP_ALIVE, 10);
        if (commonThreadPool == null) {
            commonThreadPool = new CommonThreadPool(threads, keepAlive);
            LOG.fine("Initialized common thread pool with " + threads + " threads.");
        } else {
            LOG.warning("Thread pool has already initialized.");
        }
    }

    private CommonThreadPool(int thread, long keepAlive) {
        this.threads = thread;
        AtomicInteger threadCount = new AtomicInteger(0);
        if (thread > 0) {
            this.executorService = new ThreadPoolExecutor(0, thread, keepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "twister2-common-thread-pool-" + threadCount.getAndIncrement()));
        }
    }

    public static ExecutorService getExecutor() {
        if (commonThreadPool == null) {
            throw new RuntimeException("Twister2 common thread pool has not initialized");
        }
        if (CommonThreadPool.commonThreadPool.threads == 0) {
            throw new RuntimeException("Requested common thread pool executor which is configured with 0 threads");
        }
        return CommonThreadPool.commonThreadPool.executorService;
    }

    public static int getThreadCount() {
        if (commonThreadPool == null) {
            throw new RuntimeException("Twister2 common thread pool has not initialized");
        }
        return CommonThreadPool.commonThreadPool.threads;
    }

    public static boolean isActive() {
        return commonThreadPool != null && CommonThreadPool.commonThreadPool.executorService != null && CommonThreadPool.commonThreadPool.threads > 0;
    }

    public static void close() {
        if (commonThreadPool != null && CommonThreadPool.commonThreadPool.executorService != null) {
            CommonThreadPool.commonThreadPool.executorService.shutdown();
        }
    }
}

