/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.util;

import java.math.BigInteger;
import java.util.Locale;

public final class JobIDUtils {
    private static final int MAX_JOB_ID_LENGTH = 49;
    private static final int MAX_USER_NAME_LENGTH = 9;
    private static final int MAX_TIMESTAMP_LENGTH = 8;
    private static final int MAX_JOB_NAME_LENGTH_IN_JOB_ID = 30;

    private JobIDUtils() {
    }

    public static String generateJobID(String jobName, String userName) {
        String timestamp;
        String jobNameInID = jobName;
        if (!JobIDUtils.nameConformsToK8sNamingRules(jobName, 30)) {
            jobNameInID = JobIDUtils.convertToK8sFormat(jobName, 30);
        }
        String userNameInID = userName;
        if (!JobIDUtils.nameConformsToK8sNamingRules(userName, 9)) {
            userNameInID = JobIDUtils.convertToK8sFormat(userName, 9);
        }
        if ((timestamp = JobIDUtils.timestamp()).length() > 8) {
            timestamp = timestamp.substring(timestamp.length() - 8);
        }
        if (userNameInID == null || "".equals(userNameInID)) {
            return String.format("%s-%s", jobNameInID, timestamp);
        }
        return String.format("%s-%s-%s", userNameInID, jobNameInID, timestamp);
    }

    public static boolean nameConformsToK8sNamingRules(String jName, int maxLength) {
        if (jName.length() > maxLength) {
            return false;
        }
        return jName.matches("[a-z]([-a-z0-9]*[a-z0-9])?");
    }

    public static String convertToK8sFormat(String name, int maxLength) {
        String modifiedName = name.replace("_", "-");
        modifiedName = modifiedName.replace(".", "-");
        modifiedName = modifiedName.toLowerCase(Locale.ENGLISH);
        if ((modifiedName = modifiedName.replaceAll("[^a-z0-9\\-]", "")).matches("[^a-z][-a-z0-9]*")) {
            modifiedName = "a" + modifiedName.substring(1);
        }
        if (modifiedName.matches("[-a-z0-9]*[-]")) {
            modifiedName = modifiedName.substring(0, modifiedName.length() - 1) + "z";
        }
        if (modifiedName.length() > maxLength) {
            modifiedName = modifiedName.substring(0, maxLength);
        }
        return modifiedName;
    }

    public static String timestamp() {
        long jan2019 = 1546290000000L;
        long diff = System.currentTimeMillis() - jan2019;
        return BigInteger.valueOf(diff).toString(36);
    }
}

