/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.data;

import edu.iu.dsc.tws.api.data.FileSystem;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public class Path
implements Serializable {
    private static final Logger LOG = Logger.getLogger(Path.class.getName());
    private static final long serialVersionUID = 1L;
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    public static final String CUR_DIR = ".";
    private URI uri;

    public Path() {
    }

    public Path(URI uri) {
        this.uri = uri;
    }

    public Path(String parent, String child) {
        this(new Path(parent), new Path(child));
    }

    public Path(String parent, Path child) {
        this(new Path(parent), child);
    }

    public Path(Path parent, Path child) {
        URI parentUri = parent.uri;
        Path curChild = child;
        String parentPath = parentUri.getPath();
        if (!SEPARATOR.equals(parentPath) && !"".equals(parentPath)) {
            try {
                parentUri = new URI(parentUri.getScheme(), parentUri.getAuthority(), parentUri.getPath() + SEPARATOR, null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (curChild.uri.getPath().startsWith(SEPARATOR)) {
            curChild = new Path(curChild.uri.getScheme(), curChild.uri.getAuthority(), curChild.uri.getPath().substring(1));
        }
        URI resolved = parentUri.resolve(curChild.uri);
        this.initialize(resolved.getScheme(), resolved.getAuthority(), this.normalizePath(resolved.getPath()));
    }

    public Path(String scheme, String authority, String path) {
        this.initialize(scheme, authority, this.checkAndTrimPathArg(path));
    }

    public Path(Path parent, String child) {
        this(parent, new Path(child));
    }

    public Path(String pathString) {
        String curpathString = this.checkAndTrimPathArg(pathString);
        if (this.hasWindowsDrive(curpathString, false)) {
            curpathString = SEPARATOR + curpathString;
        }
        String scheme = null;
        String authority = null;
        int start = 0;
        int colon = curpathString.indexOf(58);
        int slash = curpathString.indexOf(47);
        if (colon != -1 && (slash == -1 || colon < slash)) {
            scheme = curpathString.substring(0, colon);
            start = colon + 1;
        }
        if (curpathString.startsWith("//", start) && curpathString.length() - start > 2) {
            int nextSlash = curpathString.indexOf(47, start + 2);
            int authEnd = nextSlash > 0 ? nextSlash : curpathString.length();
            authority = curpathString.substring(start + 2, authEnd);
            start = authEnd;
        }
        String path = curpathString.substring(start, curpathString.length());
        this.initialize(scheme, authority, path);
    }

    public URI toUri() {
        return this.uri;
    }

    private void initialize(String scheme, String authority, String path) {
        try {
            this.uri = new URI(scheme, authority, this.normalizePath(path), null, null).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String normalizePath(String path) {
        String curPath = path.trim();
        curPath = curPath.replace("\\", SEPARATOR);
        if (!(curPath = curPath.replaceAll("/+", SEPARATOR)).equals(SEPARATOR) && !curPath.matches("/\\p{Alpha}+:/") && curPath.endsWith(SEPARATOR)) {
            curPath = curPath.substring(0, curPath.length() - SEPARATOR.length());
        }
        return curPath;
    }

    private String checkAndTrimPathArg(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Can not create a Path from a null string");
        }
        String curpath = path.trim();
        if (curpath.length() == 0) {
            throw new IllegalArgumentException("Can not create a Path from an empty string");
        }
        return curpath;
    }

    private boolean hasWindowsDrive(String path, boolean slashed) {
        int start = slashed ? 1 : 0;
        return path.length() >= start + 2 && (!slashed || path.charAt(0) == '/') && path.charAt(start + 1) == ':' && (path.charAt(start) >= 'A' && path.charAt(start) <= 'Z' || path.charAt(start) >= 'a' && path.charAt(start) <= 'z');
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public Path getParent() {
        String parent;
        int start;
        String path = this.uri.getPath();
        int lastSlash = path.lastIndexOf(47);
        int n = start = this.hasWindowsDrive(path, true) ? 3 : 0;
        if (path.length() == start || lastSlash == start && path.length() == start + 1) {
            return null;
        }
        if (lastSlash == -1) {
            parent = CUR_DIR;
        } else {
            int end = this.hasWindowsDrive(path, true) ? 3 : 0;
            parent = path.substring(0, lastSlash == end ? end + 1 : lastSlash);
        }
        return new Path(this.uri.getScheme(), this.uri.getAuthority(), parent);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.uri.getScheme() != null) {
            buffer.append(this.uri.getScheme());
            buffer.append(":");
        }
        if (this.uri.getAuthority() != null) {
            buffer.append("//");
            buffer.append(this.uri.getAuthority());
        }
        if (this.uri.getPath() != null) {
            String path = this.uri.getPath();
            if (path.indexOf(47) == 0 && this.hasWindowsDrive(path, true) && this.uri.getScheme() == null && this.uri.getAuthority() == null) {
                path = path.substring(1);
            }
            buffer.append(path);
        }
        return buffer.toString();
    }

    public String getName() {
        String path = this.uri.getPath();
        int slash = path.lastIndexOf(SEPARATOR);
        return path.substring(slash + 1);
    }

    public Path makeQualified(FileSystem fs) {
        Path path = this;
        if (!this.isAbsolute()) {
            path = new Path(fs.getWorkingDirectory(), this);
        }
        URI pathUri = path.toUri();
        URI fsUri = fs.getUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme != null && (authority != null || fsUri.getAuthority() == null)) {
            return path;
        }
        if (scheme == null) {
            scheme = fsUri.getScheme();
        }
        if (authority == null && (authority = fsUri.getAuthority()) == null) {
            authority = "";
        }
        return new Path(scheme + "://" + authority + pathUri.getPath());
    }

    public boolean isAbsolute() {
        int start = this.hasWindowsDrive(this.uri.getPath(), true) ? 3 : 0;
        return this.uri.getPath().startsWith(SEPARATOR, start);
    }

    public boolean isNullOrEmpty() {
        return this.uri == null || this.uri.equals("");
    }
}

