/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.data;

import edu.iu.dsc.tws.api.data.BlockLocation;
import edu.iu.dsc.tws.api.data.FSDataInputStream;
import edu.iu.dsc.tws.api.data.FSDataOutputStream;
import edu.iu.dsc.tws.api.data.FileStatus;
import edu.iu.dsc.tws.api.data.Path;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.logging.Logger;

public abstract class FileSystem
implements Serializable {
    private static final Logger LOG = Logger.getLogger(FileSystem.class.getName());

    public boolean isFile(Path path) {
        return true;
    }

    public boolean isDirectory(Path path) {
        return true;
    }

    public boolean isSymlink(Path path) {
        return true;
    }

    public abstract void setWorkingDirectory(Path var1);

    public abstract Path getWorkingDirectory();

    public abstract URI getUri();

    public abstract void initialize(URI var1) throws IOException;

    public abstract FileStatus getFileStatus(Path var1) throws IOException;

    public abstract FileStatus[] listFiles(Path var1) throws IOException;

    public abstract FSDataInputStream open(Path var1) throws IOException;

    public boolean exists(Path path) throws IOException {
        return true;
    }

    public abstract BlockLocation[] getFileBlockLocations(FileStatus var1, long var2, long var4) throws IOException;

    public abstract FSDataInputStream open(Path var1, int var2) throws IOException;

    public abstract FSDataOutputStream create(Path var1) throws IOException;

    public abstract FSDataOutputStream create(Path var1, WriteMode var2) throws IOException;

    public abstract boolean delete(Path var1, boolean var2) throws IOException;

    public abstract FileStatus[] listStatus(Path var1) throws IOException;

    public abstract boolean mkdirs(Path var1) throws IOException;

    public abstract boolean rename(Path var1, Path var2) throws IOException;

    public abstract long getDefaultBlockSize();

    public abstract boolean isDistributedFS();

    public static enum WriteMode {
        NO_OVERWRITE,
        OVERWRITE;

    }
}

