/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.resource;

import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import java.io.File;

public class FSPersistentVolume
implements IPersistentVolume {
    public static final String WORKER_DIR_NAME_PREFIX = "worker-";
    public static final String WORKER_LOG_FILE_NAME_PREFIX = "worker-";
    public static final String LOG_DIR_NAME = "/logs";
    private String jobDirPath;
    private String workerDirPath;
    private String logFileName;
    private String logDirPath;

    public FSPersistentVolume(String jobDirPath, int workerID) {
        this.jobDirPath = jobDirPath;
        this.workerDirPath = jobDirPath + File.separator + "worker-" + workerID;
        this.logDirPath = jobDirPath + LOG_DIR_NAME;
        this.logFileName = this.logDirPath + File.separator + "worker-" + workerID + ".log";
        this.createLogDir();
    }

    private void createLogDir() {
        File logDir = new File(this.logDirPath);
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
    }

    @Override
    public String getJobDirPath() {
        return this.jobDirPath;
    }

    public String getLogDirPath() {
        return this.logDirPath;
    }

    @Override
    public String getWorkerDirPath() {
        return this.workerDirPath;
    }

    @Override
    public boolean jobDirExists() {
        return new File(this.jobDirPath).exists();
    }

    @Override
    public boolean workerDirExists() {
        return new File(this.workerDirPath).exists();
    }

    @Override
    public File getJobDir() {
        File dir = new File(this.jobDirPath);
        return dir.exists() ? dir : null;
    }

    @Override
    public File getWorkerDir() {
        if (!this.jobDirExists()) {
            return null;
        }
        File workerDir = new File(this.workerDirPath);
        if (workerDir.exists()) {
            return workerDir;
        }
        workerDir.mkdir();
        return workerDir;
    }

    @Override
    public String getLogFileName() {
        return this.logFileName;
    }
}

