/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.resource;

import edu.iu.dsc.tws.api.comms.Communicator;
import edu.iu.dsc.tws.api.comms.channel.TWSChannel;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.TimeoutException;
import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import edu.iu.dsc.tws.api.resource.IVolatileVolume;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.resource.Network;
import edu.iu.dsc.tws.api.util.CommonThreadPool;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WorkerEnvironment {
    private static final Logger LOG = Logger.getLogger(WorkerEnvironment.class.getName());
    private Config config;
    private int workerId;
    private IWorkerController workerController;
    private IPersistentVolume persistentVolume;
    private IVolatileVolume volatileVolume;
    private Communicator communicator;
    private TWSChannel channel;
    private final List<JobMasterAPI.WorkerInfo> workerList;
    private static volatile WorkerEnvironment workerEnv;

    private WorkerEnvironment(Config config, int workerId, IWorkerController workerController, IPersistentVolume persistentVolume, IVolatileVolume volatileVolume) {
        this.config = config;
        this.workerId = workerId;
        this.workerController = workerController;
        this.persistentVolume = persistentVolume;
        this.volatileVolume = volatileVolume;
        CommonThreadPool.init((Config)config);
        try {
            this.workerList = workerController.getAllWorkers();
        }
        catch (TimeoutException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException("Unable to get the worker list", e);
        }
        this.channel = Network.initializeChannel(config, workerController);
        this.communicator = new Communicator(config, this.channel);
    }

    public Config getConfig() {
        return this.config;
    }

    public int getWorkerId() {
        return this.workerId;
    }

    public int getNumberOfWorkers() {
        return this.workerController.getNumberOfWorkers();
    }

    public List<JobMasterAPI.WorkerInfo> getWorkerList() {
        return this.workerList;
    }

    public IWorkerController getWorkerController() {
        return this.workerController;
    }

    public IPersistentVolume getPersistentVolume() {
        return this.persistentVolume;
    }

    public IVolatileVolume getVolatileVolume() {
        return this.volatileVolume;
    }

    public Communicator getCommunicator() {
        return this.communicator;
    }

    public TWSChannel getChannel() {
        return this.channel;
    }

    public void close() {
        this.communicator.close();
        this.channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WorkerEnvironment init(Config config, int workerId, IWorkerController workerController, IPersistentVolume persistentVolume, IVolatileVolume volatileVolume) {
        if (workerEnv != null) return workerEnv;
        Class<WorkerEnvironment> clazz = WorkerEnvironment.class;
        synchronized (WorkerEnvironment.class) {
            if (workerEnv != null) return workerEnv;
            workerEnv = new WorkerEnvironment(config, workerId, workerController, persistentVolume, volatileVolume);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return workerEnv;
        }
    }
}

