/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.compute.graph;

import edu.iu.dsc.tws.api.compute.graph.BaseDataflowTaskGraph;
import edu.iu.dsc.tws.api.compute.graph.DirectedEdge;
import edu.iu.dsc.tws.api.compute.graph.Edge;
import edu.iu.dsc.tws.api.compute.graph.OperationMode;
import edu.iu.dsc.tws.api.compute.graph.Vertex;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ComputeGraph
extends BaseDataflowTaskGraph<Vertex, Edge> {
    private static final Logger LOG = Logger.getLogger(ComputeGraph.class.getName());
    private Map<String, Vertex> taskMap = new HashMap<String, Vertex>();
    private Map<String, String> graphConstraintsMap = new HashMap<String, String>();
    private Map<String, Map<String, String>> nodeConstraintsMap = new HashMap<String, Map<String, String>>();
    private OperationMode operationMode = OperationMode.STREAMING;
    private String graphName;

    public ComputeGraph() {
        super(new VertexComparator(), new EdgeComparator());
    }

    public ComputeGraph(OperationMode mode) {
        this(mode, "unnamed-task-graph");
    }

    public ComputeGraph(OperationMode mode, String graphName) {
        super(new VertexComparator(), new EdgeComparator());
        this.operationMode = mode;
        this.graphName = graphName;
    }

    @Override
    public void build() {
        this.validate();
        for (DirectedEdge de : this.getDirectedEdgesSet()) {
            this.taskMap.put(((Vertex)de.getSourceVertex()).getName(), (Vertex)de.getSourceVertex());
            this.taskMap.put(((Vertex)de.getTargetVertex()).getName(), (Vertex)de.getTargetVertex());
        }
    }

    @Override
    public String getGraphName() {
        return this.graphName;
    }

    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public boolean addTaskVertex(String name, Vertex taskVertex) {
        if (!this.validateTaskVertex(name)) {
            this.addTaskVertex(taskVertex);
            this.taskMap.put(name, taskVertex);
        }
        return true;
    }

    public void addNodeConstraints(Map<String, Map<String, String>> nodeConstraintsmap) {
        this.nodeConstraintsMap = nodeConstraintsmap;
    }

    public void addGraphConstraints(Map<String, String> graphConstraintsmap) {
        this.graphConstraintsMap = graphConstraintsmap;
    }

    public Map<String, String> getGraphConstraints() {
        return this.graphConstraintsMap;
    }

    public Map<String, Map<String, String>> getNodeConstraints() {
        return this.nodeConstraintsMap;
    }

    private boolean validateTaskVertex(String taskName) {
        boolean flag = false;
        if (this.taskMap.containsKey(taskName)) {
            throw new RuntimeException("Duplicate names for the submitted task:" + taskName);
        }
        return flag;
    }

    public Vertex vertex(String name) {
        return this.taskMap.get(name);
    }

    public Set<Edge> outEdges(Vertex task) {
        return this.outgoingTaskEdgesOf(task);
    }

    public Set<Edge> outEdges(String taskName) {
        Vertex t = this.taskMap.get(taskName);
        if (t == null) {
            return new HashSet<Edge>();
        }
        return this.outEdges(t);
    }

    public Set<Edge> inEdges(Vertex task) {
        return this.incomingTaskEdgesOf(task);
    }

    public Set<Edge> inEdges(String taskName) {
        Vertex t = this.taskMap.get(taskName);
        if (t == null) {
            return new HashSet<Edge>();
        }
        return this.inEdges(t);
    }

    @Override
    public Set<Vertex> childrenOfTask(String taskName) {
        Vertex t = this.taskMap.get(taskName);
        if (t == null) {
            return new HashSet<Vertex>();
        }
        return this.childrenOfTask(t);
    }

    @Override
    public Set<Vertex> parentsOfTask(String taskName) {
        Vertex t = this.taskMap.get(taskName);
        if (t == null) {
            return new HashSet<Vertex>();
        }
        return this.parentsOfTask(t);
    }

    public Vertex childOfTask(Vertex task, String edge) {
        Set<Edge> edges = this.outEdges(task);
        Edge taskEdge = null;
        for (Edge e : edges) {
            if (!e.getName().equals(edge)) continue;
            taskEdge = e;
        }
        if (taskEdge != null) {
            return this.connectedChildTask(task, taskEdge);
        }
        return null;
    }

    public Vertex getParentOfTask(Vertex task, String edge) {
        Set<Edge> edges = this.inEdges(task);
        Edge taskEdge = null;
        for (Edge e : edges) {
            if (!e.getName().equals(edge)) continue;
            taskEdge = e;
        }
        if (taskEdge != null) {
            return this.connectedParentTask(task, taskEdge);
        }
        return null;
    }

    public OperationMode getOperationMode() {
        return this.operationMode;
    }

    public void setOperationMode(OperationMode operationMode) {
        this.operationMode = operationMode;
    }

    public static class StringComparator
    implements Comparator<String> {
        @Override
        public int compare(String obj1, String obj2) {
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            if (obj1.equals(obj2)) {
                return 0;
            }
            return obj1.compareTo(obj2);
        }
    }

    private static class EdgeComparator
    implements Comparator<Edge> {
        private EdgeComparator() {
        }

        @Override
        public int compare(Edge o1, Edge o2) {
            return new StringComparator().compare(o1.getName(), o2.getName());
        }
    }

    private static class VertexComparator
    implements Comparator<Vertex> {
        private VertexComparator() {
        }

        @Override
        public int compare(Vertex o1, Vertex o2) {
            return new StringComparator().compare(o1.getName(), o2.getName());
        }
    }
}

