/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.compute.schedule.elements;

public class Resource {
    private Double ram;
    private Double disk;
    private Double cpu;
    private int id;

    public int getId() {
        return this.id;
    }

    public Resource setId(int idx) {
        this.id = idx;
        return this;
    }

    public Resource(Double ram, Double disk, Double cpu) {
        this.ram = ram;
        this.disk = disk;
        this.cpu = cpu;
    }

    public Resource(Double ram, Double disk, Double cpu, Integer idx) {
        this.ram = ram;
        this.disk = disk;
        this.cpu = cpu;
        this.id = idx;
    }

    public boolean equals(Object o) {
        if (o instanceof Resource) {
            Resource r = (Resource)o;
            return this.getCpu().equals(r.getCpu()) && this.getRam().equals(r.getRam()) && this.getDisk().equals(r.getDisk());
        }
        return false;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.cpu);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + this.ram.hashCode();
        result = 31 * result + this.disk.hashCode();
        return result;
    }

    public Double getRam() {
        return this.ram;
    }

    public void setRam(Double ram) {
        this.ram = ram;
    }

    public Double getDisk() {
        return this.disk;
    }

    public void setDisk(Double disk) {
        this.disk = disk;
    }

    public Double getCpu() {
        return this.cpu;
    }

    public void setCpu(Double cpu) {
        this.cpu = cpu;
    }

    public Resource cloneWithRam(double newRam) {
        return new Resource(newRam, this.getDisk(), this.getCpu());
    }

    public Resource cloneWithRam(double newRam, double newDisk, double newCpu) {
        return new Resource(newRam, newDisk, newCpu);
    }
}

