//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
package edu.iu.dsc.tws.api.compute;

/**
 * Wrapper interface for all the messages types.
 */
public interface IMessage<T> {
  /**
   * Returns the content of the message
   *
   * @return content of the message
   */
  T getContent();

  /**
   * The edge this message is traveling
   *
   * @return the edge identifier
   */
  String edge();

  /**
   * Returns the flag of the message
   * @return flag of the message
   */
  int getFlag();

  /**
   * Get the source of the message
   * @return source id
   */
  int sourceTask();

  /**
   * Set a flag to the message
   * @param barrier barrier message
   */
  void setFlag(int barrier);
}
