/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.compute;

import edu.iu.dsc.tws.api.compute.graph.OperationMode;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskInstancePlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.WorkerSchedulePlan;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface TaskContext {
    public void reset();

    public int taskIndex();

    public int globalTaskId();

    public int taskId();

    public String taskName();

    public int getParallelism();

    public int getWorkerId();

    public Map<String, Object> getConfigurations();

    public Object getConfig(String var1);

    public Map<String, String> getOutEdges();

    public Map<String, Set<String>> getInEdges();

    public boolean write(String var1, Object var2, Object var3);

    public boolean write(String var1, Object var2);

    public boolean writeBarrier(String var1, Object var2);

    public boolean writeEnd(String var1, Object var2);

    public boolean writeEnd(String var1, Object var2, Object var3);

    public void end(String var1);

    public void endAll();

    public boolean isDone(String var1);

    public Set<WorkerSchedulePlan> getWorkers();

    public Map<Integer, WorkerSchedulePlan> getWorkersMap();

    default public WorkerSchedulePlan getWorker() {
        return this.getWorkersMap().get(this.getWorkerId());
    }

    default public Set<TaskInstancePlan> getTasksByName(String name) {
        return this.getWorkers().stream().flatMap(worker -> worker.getTaskInstances().stream()).filter(taskInstancePlan -> taskInstancePlan.getTaskName().equals(name)).collect(Collectors.toSet());
    }

    default public Set<TaskInstancePlan> getTasksInThisWorkerByName(String name) {
        return this.getWorker().getTaskInstances().stream().filter(taskInstancePlan -> taskInstancePlan.getTaskName().equals(name)).collect(Collectors.toSet());
    }

    public OperationMode getOperationMode();
}

