/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.compute.executor;

import edu.iu.dsc.tws.api.compute.executor.ExecutionState;
import edu.iu.dsc.tws.api.compute.executor.INodeInstance;
import edu.iu.dsc.tws.api.compute.executor.IParallelOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class ExecutionPlan {
    private String id;
    private Map<Integer, INodeInstance> nodes = new HashMap<Integer, INodeInstance>();
    private Map<String, Map<Integer, INodeInstance>> nodesByName = new HashMap<String, Map<Integer, INodeInstance>>();
    private List<IParallelOperation> parallelOperations = new ArrayList<IParallelOperation>();
    private ExecutionState executionState;

    public ExecutionPlan() {
        this.id = UUID.randomUUID().toString();
        this.executionState = ExecutionState.INIT;
    }

    public void addNodes(String name, int taskId, INodeInstance node) {
        Map<Object, Object> instances;
        this.nodes.put(taskId, node);
        if (!this.nodesByName.containsKey(name)) {
            instances = new HashMap();
            this.nodesByName.put(name, instances);
        } else {
            instances = this.nodesByName.get(name);
        }
        instances.put(taskId, node);
    }

    public Map<Integer, INodeInstance> getNodes() {
        return this.nodes;
    }

    public void addOps(IParallelOperation op) {
        this.parallelOperations.add(op);
    }

    public List<IParallelOperation> getParallelOperations() {
        return this.parallelOperations;
    }

    public boolean isNodeAvailable(String taskName) {
        return this.nodesByName.containsKey(taskName);
    }

    public Map<Integer, INodeInstance> getNodes(String taskName) {
        return this.nodesByName.get(taskName);
    }

    public Set<String> getNodeNames() {
        return this.nodesByName.keySet();
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionPlan plan = (ExecutionPlan)o;
        return Objects.equals(this.id, plan.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "ExecutionPlan{nodes=" + this.nodes + ", nodesName=" + this.nodesByName + ", parOps=" + this.parallelOperations + "}";
    }
}

