/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.compute.graph;

import edu.iu.dsc.tws.api.compute.nodes.INode;
import edu.iu.dsc.tws.api.config.Config;
import java.util.HashMap;
import java.util.Map;

public class Vertex {
    private String name;
    private INode task;
    private int cpu;
    private int memory;
    private int ram;
    private int parallelism = 1;
    private Map<String, Object> config;

    public Vertex() {
    }

    public Vertex(String n, INode t) {
        this.name = n;
        this.task = t;
        this.config = new HashMap<String, Object>();
    }

    public Vertex(String name, INode task, int parallelism) {
        this.name = name;
        this.task = task;
        this.parallelism = parallelism;
        this.config = new HashMap<String, Object>();
    }

    public int getRam() {
        return this.ram;
    }

    public void setRam(int ram) {
        this.ram = ram;
    }

    public INode getTask() {
        return this.task;
    }

    public Config getConfig() {
        return Config.newBuilder().putAll(this.config).build();
    }

    public String getName() {
        return this.name;
    }

    public int getCpu() {
        return this.cpu;
    }

    public int getMemory() {
        return this.memory;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setCpu(int cpu) {
        this.cpu = cpu;
    }

    public void setMemory(int memory) {
        this.memory = memory;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public void addConfiguration(String key, Object val) {
        this.config.put(key, val);
    }
}

