/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.compute.schedule.elements;

import edu.iu.dsc.tws.api.compute.schedule.elements.Resource;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskInstancePlan;
import edu.iu.dsc.tws.api.compute.schedule.elements.WorkerSchedulePlan;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TaskSchedulePlan {
    private final Set<WorkerSchedulePlan> containers;
    private final Map<Integer, WorkerSchedulePlan> containersMap;
    private int jobId;

    public TaskSchedulePlan(int id, Set<WorkerSchedulePlan> containers) {
        this.jobId = id;
        this.containers = Collections.unmodifiableSet(containers);
        this.containersMap = new TreeMap<Integer, WorkerSchedulePlan>();
        for (WorkerSchedulePlan workerSchedulePlan : containers) {
            this.containersMap.put(workerSchedulePlan.getContainerId(), workerSchedulePlan);
        }
    }

    public Resource getMaxContainerResources() {
        double maxCpu = 0.0;
        double maxRam = 0.0;
        double maxDisk = 0.0;
        for (WorkerSchedulePlan workerSchedulePlan : this.getContainers()) {
            Resource containerResource = workerSchedulePlan.getScheduledResource().orElse(workerSchedulePlan.getRequiredResource());
            maxCpu = Math.max(maxCpu, containerResource.getCpu());
            maxRam = Math.max(maxRam, containerResource.getRam());
            maxDisk = Math.max(maxDisk, containerResource.getDisk());
        }
        return new Resource(maxRam, maxDisk, maxCpu);
    }

    private int getTaskSchedulePlanId() {
        return this.jobId;
    }

    public Map<Integer, WorkerSchedulePlan> getContainersMap() {
        return this.containersMap;
    }

    public Set<WorkerSchedulePlan> getContainers() {
        return this.containers;
    }

    public Map<String, Integer> getTaskCounts() {
        HashMap<String, Integer> taskCounts = new HashMap<String, Integer>();
        for (WorkerSchedulePlan workerSchedulePlan : this.getContainers()) {
            for (TaskInstancePlan instancePlan : workerSchedulePlan.getTaskInstances()) {
                Integer count = 0;
                if (taskCounts.containsKey(instancePlan.getTaskName())) {
                    count = (Integer)taskCounts.get(instancePlan.getTaskName());
                }
                count = count + 1;
                taskCounts.put(instancePlan.getTaskName(), count);
            }
        }
        return taskCounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskSchedulePlan)) {
            return false;
        }
        TaskSchedulePlan that = (TaskSchedulePlan)o;
        return this.getTaskSchedulePlanId() == that.getTaskSchedulePlanId() && this.getContainers().equals(that.getContainers());
    }

    public int hashCode() {
        int result = this.containers.hashCode();
        result = 31 * result + this.jobId;
        return result;
    }

    public String toString() {
        return "TaskSchedulePlan{containers=" + this.containersMap + "}";
    }
}

