/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.compute.graph;

import edu.iu.dsc.tws.api.compute.graph.DirectedEdge;
import edu.iu.dsc.tws.api.compute.graph.ITaskGraph;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;

public abstract class BaseDataflowTaskGraph<TV, TE>
implements ITaskGraph<TV, TE> {
    private LinkedHashSet<TV> vertices;
    private Set<DirectedEdge<TV, TE>> directedEdges;
    private Comparator<TV> vertexComparator;
    private Comparator<TE> edgeComparator;
    private static final Logger LOG = Logger.getLogger(BaseDataflowTaskGraph.class.getName());

    public BaseDataflowTaskGraph() {
    }

    public BaseDataflowTaskGraph(Comparator<TV> comparator, Comparator<TE> eComparator) {
        this.vertices = new LinkedHashSet();
        this.directedEdges = new LinkedHashSet<DirectedEdge<TV, TE>>();
        this.vertexComparator = comparator;
        this.edgeComparator = eComparator;
    }

    @Override
    public boolean addTaskVertex(TV taskVertex) {
        if (taskVertex == null) {
            throw new NullPointerException();
        }
        if (this.containsTaskVertex(taskVertex)) {
            return false;
        }
        this.vertices.add(taskVertex);
        return true;
    }

    @Override
    public TE addTaskEdge(TV sourceTaskVertex, TV targetTaskVertex) {
        throw new UnsupportedOperationException("Undirected edge of type TE can not be returned when adding a task edge!");
    }

    @Override
    public boolean addTaskEdge(TV taskVertex1, TV taskVertex2, TE taskEdge) {
        if (taskEdge == null) {
            throw new NullPointerException();
        }
        if (this.containsTaskEdge(taskVertex1, taskVertex2, taskEdge)) {
            return false;
        }
        this.validateTaskVertex(taskVertex1);
        this.validateTaskVertex(taskVertex2);
        DirectedEdge<TV, TE> directedEdge = new DirectedEdge<TV, TE>(taskVertex1, taskVertex2, taskEdge);
        this.directedEdges.add(directedEdge);
        return true;
    }

    @Override
    public Set<TE> getAllTaskEdges(TV sourceTaskVertex, TV targetTaskVertex) {
        LinkedHashSet<TE> edgeSet = new LinkedHashSet<TE>();
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (this.vertexComparator.compare(de.getSourceVertex(), sourceTaskVertex) != 0 || this.vertexComparator.compare(de.getTargetVertex(), targetTaskVertex) != 0) continue;
            edgeSet.add(de.getTaskEdge());
        }
        return edgeSet;
    }

    @Override
    public boolean containsTaskEdge(TE taskEdge) {
        throw new UnsupportedOperationException("Unsafe method because of the DEFAULT EDGE!");
    }

    @Override
    public boolean containsTaskVertex(TV taskVertex) {
        return this.vertices.contains(taskVertex);
    }

    @Override
    public Set<TE> incomingTaskEdgesOf(TV taskVertex) {
        LinkedHashSet<TE> ret = new LinkedHashSet<TE>();
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (this.vertexComparator.compare(de.getTargetVertex(), taskVertex) != 0) continue;
            ret.add(de.getTaskEdge());
        }
        return ret;
    }

    @Override
    public int outDegreeOfTask(TV taskVertex) {
        return this.outgoingTaskEdgesOf(taskVertex).size();
    }

    @Override
    public TE removeTaskEdge(TV sourceVertex, TV targetVertex) {
        Iterator<DirectedEdge<TV, TE>> it = this.directedEdges.iterator();
        while (it.hasNext()) {
            DirectedEdge<TV, TE> de = it.next();
            if (this.vertexComparator.compare(de.getSourceVertex(), sourceVertex) != 0 || this.vertexComparator.compare(de.getTargetVertex(), targetVertex) != 0) continue;
            it.remove();
            return de.getTaskEdge();
        }
        return null;
    }

    @Override
    public boolean removeTaskEdge(TE taskEdge) {
        Iterator<DirectedEdge<TV, TE>> it = this.directedEdges.iterator();
        while (it.hasNext()) {
            DirectedEdge<TV, TE> de = it.next();
            if (this.edgeComparator.compare(taskEdge, de.getTaskEdge()) != 0) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTaskVertex(TV taskVertex) {
        this.directedEdges.removeIf(de -> this.vertexComparator.compare(taskVertex, de.getSourceVertex()) == 0 || this.vertexComparator.compare(taskVertex, de.getTargetVertex()) == 0);
        return this.vertices.remove(taskVertex);
    }

    @Override
    public Set<TV> getTaskVertexSet() {
        return this.vertices;
    }

    public Set<DirectedEdge<TV, TE>> getDirectedEdgesSet() {
        return this.directedEdges;
    }

    @Override
    public Set<TE> taskEdgeSet() {
        LinkedHashSet edges = new LinkedHashSet();
        this.directedEdges.forEach(de -> edges.add(de.getTaskEdge()));
        return edges;
    }

    public TV connectedChildTask(TV task, TE edge) {
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (this.vertexComparator.compare(task, de.getSourceVertex()) != 0 || this.edgeComparator.compare(de.getTaskEdge(), edge) != 0) continue;
            return de.getTargetVertex();
        }
        return null;
    }

    public TV connectedParentTask(TV task, TE edge) {
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (this.vertexComparator.compare(task, de.getTargetVertex()) != 0 || this.edgeComparator.compare(de.getTaskEdge(), edge) != 0) continue;
            return de.getSourceVertex();
        }
        return null;
    }

    @Override
    public Set<TE> taskEdgesOf(TV taskVertex) {
        LinkedHashSet<TE> ret = new LinkedHashSet<TE>();
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (this.vertexComparator.compare(taskVertex, de.getSourceVertex()) != 0 && this.vertexComparator.compare(taskVertex, de.getTargetVertex()) != 0) continue;
            ret.add(de.getTaskEdge());
        }
        return ret;
    }

    @Override
    public Set<TE> outgoingTaskEdgesOf(TV taskVertex) {
        LinkedHashSet<TE> ret = new LinkedHashSet<TE>();
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (this.vertexComparator.compare(de.getSourceVertex(), taskVertex) != 0) continue;
            ret.add(de.getTaskEdge());
        }
        return ret;
    }

    public Set<TV> childrenOfTask(TV t) {
        LinkedHashSet<TV> ret = new LinkedHashSet<TV>();
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (this.vertexComparator.compare(de.getSourceVertex(), t) != 0) continue;
            ret.add(de.getTargetVertex());
        }
        return ret;
    }

    public Set<TV> parentsOfTask(TV t) {
        LinkedHashSet<TV> ret = new LinkedHashSet<TV>();
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (this.vertexComparator.compare(de.getTargetVertex(), t) != 0) continue;
            ret.add(de.getSourceVertex());
        }
        return ret;
    }

    @Override
    public int inDegreeOfTask(TV taskVertex) {
        return this.incomingTaskEdgesOf(taskVertex).size();
    }

    @Override
    public boolean containsTaskEdge(TV sourceTaskVertex, TV targetTaskVertex) {
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (this.vertexComparator.compare(de.getSourceVertex(), sourceTaskVertex) != 0 || this.vertexComparator.compare(de.getTargetVertex(), targetTaskVertex) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean containsTaskEdge(TV sourceTaskVertex, TV targetTaskVertex, TE taskEdge) {
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (this.edgeComparator.compare(de.getTaskEdge(), taskEdge) != 0 || this.vertexComparator.compare(de.getSourceVertex(), sourceTaskVertex) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAllTaskEdges(Collection<? extends TE> taskEdges) {
        boolean success = false;
        for (TE taskEdge : taskEdges) {
            success |= this.removeTaskEdge(taskEdge);
        }
        return success;
    }

    @Override
    public boolean removeAllTaskVertices(Collection<? extends TV> taskVertices) {
        boolean flag = false;
        for (TV taskVertex : taskVertices) {
            flag |= this.removeTaskVertex(taskVertex);
        }
        return flag;
    }

    @Override
    public Set<TE> removeAllTaskEdges(TV sourceTaskVertex, TV targetTaskVertex) {
        LinkedHashSet<TE> removedTaskEdges = new LinkedHashSet<TE>();
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (this.vertexComparator.compare(de.getSourceVertex(), sourceTaskVertex) != 0 || this.vertexComparator.compare(de.getTargetVertex(), targetTaskVertex) != 0) continue;
            removedTaskEdges.add(de.getTaskEdge());
            this.directedEdges.remove(de);
        }
        return removedTaskEdges;
    }

    public DirectedEdge<TV, TE> getDataflowTaskEdge(TE taskEdge) {
        return null;
    }

    public boolean validate() {
        return !this.detectSelfLoop();
    }

    protected void validateTaskVertex(TV taskVertex) {
        if (!this.containsTaskVertex(taskVertex)) {
            throw new RuntimeException("No task vertex in this task graph: " + taskVertex.toString());
        }
    }

    private boolean detectSelfLoop() {
        for (DirectedEdge<TV, TE> de : this.directedEdges) {
            if (!de.getSourceVertex().equals(de.getTargetVertex())) continue;
            throw new RuntimeException(String.format("Self-loop detected for the task graph in edge %s between %s and %s", de.getTaskEdge(), de.getSourceVertex(), de.getTargetVertex()));
        }
        return true;
    }

    public boolean hasCycle() {
        Set<TV> taskVertexSet = this.getTaskVertexSet();
        LinkedHashSet sourceTaskVertex = new LinkedHashSet();
        LinkedHashSet targetTaskVertex = new LinkedHashSet();
        while (taskVertexSet.size() > 0) {
            TV taskVertex = taskVertexSet.iterator().next();
            if (!this.detectCycle(taskVertex, taskVertexSet, sourceTaskVertex, targetTaskVertex)) continue;
            throw new RuntimeException("Cycle is detected for the vertex:" + taskVertex);
        }
        return false;
    }

    private boolean detectCycle(TV vertex, Set<TV> taskVertexSet, Set<TV> sourceTaskSet, Set<TV> targetTaskSet) {
        this.traversedVertex(vertex, taskVertexSet, sourceTaskSet);
        for (TV childTask : this.childrenOfTask(vertex)) {
            if (sourceTaskSet.contains(childTask)) {
                return true;
            }
            if (!this.detectCycle(childTask, taskVertexSet, sourceTaskSet, targetTaskSet)) continue;
            return true;
        }
        this.traversedVertex(vertex, sourceTaskSet, targetTaskSet);
        return false;
    }

    private void traversedVertex(TV vertex, Set<TV> sourceTaskSet, Set<TV> targetTaskSet) {
        sourceTaskSet.remove(vertex);
        targetTaskSet.add(vertex);
    }

    public abstract void build();
}

