/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.compute.graph;

import edu.iu.dsc.tws.api.comms.messaging.types.MessageType;
import edu.iu.dsc.tws.api.comms.messaging.types.MessageTypes;
import edu.iu.dsc.tws.api.comms.packing.MessageSchema;
import edu.iu.dsc.tws.api.compute.IFunction;
import edu.iu.dsc.tws.api.compute.TaskPartitioner;
import edu.iu.dsc.tws.api.compute.graph.EdgeID;
import java.util.HashMap;
import java.util.Map;

public class Edge {
    private String name;
    private IFunction function;
    private TaskPartitioner partitioner;
    private String operation;
    private MessageType dataType = MessageTypes.OBJECT;
    private MessageType keyType = MessageTypes.OBJECT;
    private boolean keyed = false;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String targetEdge;
    private int edgeIndex;
    private int numberOfEdges;
    private MessageSchema messageSchema = MessageSchema.noSchema();
    private EdgeID edgeID = new EdgeID();

    public Edge() {
    }

    public Edge(String te) {
        this.name = te;
    }

    public Edge(String name, String operation) {
        this.name = name;
        this.operation = operation;
    }

    public Edge(String taskEdge, IFunction function) {
        this.name = taskEdge;
        this.function = function;
    }

    public Edge(String name, String operation, MessageType dataType) {
        this.name = name;
        this.operation = operation;
        this.dataType = dataType;
    }

    public Edge(String name, String operation, IFunction function) {
        this.name = name;
        this.function = function;
        this.operation = operation;
    }

    public Edge(String name, String operation, MessageType dataType, MessageType keyType) {
        this.name = name;
        this.operation = operation;
        this.dataType = dataType;
        this.keyType = keyType;
        this.keyed = true;
    }

    public Edge(String name, String operation, MessageType dataType, MessageType keyType, IFunction function) {
        this.name = name;
        this.function = function;
        this.operation = operation;
        this.dataType = dataType;
        this.keyType = keyType;
        this.keyed = true;
    }

    public Edge(String name, String operation, MessageType dataType, IFunction function) {
        this.name = name;
        this.function = function;
        this.operation = operation;
        this.dataType = dataType;
    }

    public Edge(String name, String operation, MessageType dataType, MessageType keyType, IFunction function, TaskPartitioner part) {
        this.name = name;
        this.function = function;
        this.operation = operation;
        this.dataType = dataType;
        this.keyType = keyType;
        this.keyed = true;
        this.partitioner = part;
    }

    public void setMessageSchema(MessageSchema messageSchema) {
        this.messageSchema = messageSchema;
    }

    public MessageSchema getMessageSchema() {
        return this.messageSchema;
    }

    public String getName() {
        return this.name;
    }

    public IFunction getFunction() {
        return this.function;
    }

    public String getOperation() {
        return this.operation;
    }

    public MessageType getDataType() {
        return this.dataType;
    }

    public MessageType getKeyType() {
        return this.keyType;
    }

    public boolean isKeyed() {
        return this.keyed;
    }

    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void addProperties(Map<String, Object> props) {
        this.properties.putAll(props);
    }

    public TaskPartitioner getPartitioner() {
        return this.partitioner;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFunction(IFunction function) {
        this.function = function;
    }

    public void setPartitioner(TaskPartitioner partitioner) {
        this.partitioner = partitioner;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setDataType(MessageType dataType) {
        this.dataType = dataType;
    }

    public void setKeyType(MessageType keyType) {
        this.keyType = keyType;
    }

    public void setKeyed(boolean keyed) {
        this.keyed = keyed;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String getTargetEdge() {
        return this.targetEdge;
    }

    public void setTargetEdge(String targetEdge) {
        this.targetEdge = targetEdge;
    }

    public void setEdgeIndex(int edgeIndex) {
        this.edgeIndex = edgeIndex;
    }

    public void setNumberOfEdges(int numberOfEdges) {
        this.numberOfEdges = numberOfEdges;
    }

    public int getEdgeIndex() {
        return this.edgeIndex;
    }

    public int getNumberOfEdges() {
        return this.numberOfEdges;
    }

    public EdgeID getEdgeID() {
        return this.edgeID;
    }
}

