/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.compute.schedule.elements;

import edu.iu.dsc.tws.api.compute.schedule.elements.Resource;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskInstanceId;

public class TaskInstancePlan
implements Comparable<TaskInstancePlan> {
    private final String taskName;
    private final int taskId;
    private final int taskIndex;
    private final Resource resource;

    public TaskInstancePlan(String taskName, int taskId, int taskIndex, Resource resource) {
        this.taskName = taskName;
        this.taskId = taskId;
        this.taskIndex = taskIndex;
        this.resource = resource;
    }

    public TaskInstancePlan(TaskInstanceId taskInstanceId, Resource resource) {
        this.taskName = taskInstanceId.getTaskName();
        this.taskId = taskInstanceId.getTaskId();
        this.taskIndex = taskInstanceId.getTaskIndex();
        this.resource = resource;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public int getTaskIndex() {
        return this.taskIndex;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInstancePlan that = (TaskInstancePlan)o;
        return this.getTaskName().equals(that.getTaskName()) && this.getTaskId() == that.getTaskId() && this.getTaskIndex() == that.getTaskIndex() && this.getResource().equals(that.getResource());
    }

    public int hashCode() {
        int result = this.getTaskName().hashCode();
        result = 31 * result + Integer.valueOf(this.getTaskId()).hashCode();
        result = 31 * result + Integer.valueOf(this.getTaskIndex()).hashCode();
        result = 31 * result + this.getResource().hashCode();
        return result;
    }

    @Override
    public int compareTo(TaskInstancePlan o) {
        if (this.taskId == o.getTaskId()) {
            return Integer.compare(this.taskIndex, o.taskIndex);
        }
        return Integer.compare(this.taskId, o.taskId);
    }
}

