/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.api.compute.schedule.elements;

import edu.iu.dsc.tws.api.compute.schedule.elements.Resource;
import edu.iu.dsc.tws.api.compute.schedule.elements.TaskInstancePlan;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public class WorkerSchedulePlan
implements Comparable<WorkerSchedulePlan> {
    private final int containerId;
    private final Set<TaskInstancePlan> taskInstances;
    private final Resource requiredResource;
    private final Optional<Resource> scheduledResource;

    public WorkerSchedulePlan(int id, Set<TaskInstancePlan> instances, Resource requiredResource) {
        this(id, instances, requiredResource, null);
    }

    public WorkerSchedulePlan(int id, Set<TaskInstancePlan> taskInstances, Resource requiredResource, Resource scheduledResource) {
        this.containerId = id;
        this.taskInstances = new TreeSet<TaskInstancePlan>(taskInstances);
        this.requiredResource = requiredResource;
        this.scheduledResource = Optional.ofNullable(scheduledResource);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public Set<TaskInstancePlan> getTaskInstances() {
        return this.taskInstances;
    }

    public Resource getRequiredResource() {
        return this.requiredResource;
    }

    public Optional<Resource> getScheduledResource() {
        return this.scheduledResource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerSchedulePlan that = (WorkerSchedulePlan)o;
        return this.containerId == that.containerId && this.getRequiredResource().equals(that.getRequiredResource()) && this.getScheduledResource().equals(that.getScheduledResource());
    }

    public int hashCode() {
        int result = this.containerId;
        result = 31 * result + this.getTaskInstances().hashCode();
        result = 31 * result + this.getRequiredResource().hashCode();
        if (this.scheduledResource.isPresent()) {
            result = 31 * result + this.getScheduledResource().get().hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(WorkerSchedulePlan o) {
        return Integer.compare(this.containerId, o.containerId);
    }
}

