/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task;

import edu.iu.dsc.tws.api.compute.executor.ExecutionPlan;
import edu.iu.dsc.tws.api.compute.graph.ComputeGraph;
import edu.iu.dsc.tws.api.compute.graph.OperationMode;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.TimeoutException;
import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import edu.iu.dsc.tws.api.resource.IVolatileVolume;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.resource.WorkerEnvironment;
import edu.iu.dsc.tws.task.impl.ComputeGraphBuilder;
import edu.iu.dsc.tws.task.impl.TaskExecutor;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ComputeEnvironment {
    private static final Logger LOG = Logger.getLogger(ComputeEnvironment.class.getName());
    private WorkerEnvironment workerEnvironment;
    private TaskExecutor taskExecutor;
    private static int taskGraphIndex = 0;

    private ComputeEnvironment(Config config, int workerId, IWorkerController wController, IPersistentVolume pVolume, IVolatileVolume vVolume) {
        this.workerEnvironment = WorkerEnvironment.init((Config)config, (int)workerId, (IWorkerController)wController, (IPersistentVolume)pVolume, (IVolatileVolume)vVolume);
        this.taskExecutor = new TaskExecutor(this.workerEnvironment);
    }

    private ComputeEnvironment(WorkerEnvironment workerEnv) {
        this.workerEnvironment = workerEnv;
        this.taskExecutor = new TaskExecutor(workerEnv);
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public TaskExecutor buildAndExecute(ComputeGraphBuilder computeGraphBuilder) {
        ComputeGraph computeGraph = computeGraphBuilder.build();
        ExecutionPlan plan = this.getTaskExecutor().plan(computeGraph);
        this.getTaskExecutor().execute(computeGraph, plan);
        return this.getTaskExecutor();
    }

    public ComputeGraphBuilder newTaskGraph(OperationMode operationMode) {
        return this.newTaskGraph(operationMode, "task-graph-" + taskGraphIndex++);
    }

    public ComputeGraphBuilder newTaskGraph(OperationMode operationMode, String name) {
        ComputeGraphBuilder computeGraphBuilder = ComputeGraphBuilder.newBuilder(this.workerEnvironment.getConfig());
        computeGraphBuilder.setMode(operationMode);
        computeGraphBuilder.setTaskGraphName(name);
        return computeGraphBuilder;
    }

    public static ComputeEnvironment init(Config config, int workerId, IWorkerController wController, IPersistentVolume pVolume, IVolatileVolume vVolume) {
        return new ComputeEnvironment(config, workerId, wController, pVolume, vVolume);
    }

    public static ComputeEnvironment init(WorkerEnvironment workerEnv) {
        return new ComputeEnvironment(workerEnv);
    }

    public void close() {
        try {
            this.workerEnvironment.getWorkerController().waitOnBarrier();
        }
        catch (TimeoutException timeoutException) {
            LOG.log(Level.SEVERE, timeoutException.getMessage(), timeoutException);
        }
        this.taskExecutor.close();
    }

    public Map<String, ExecutionPlan> build(ComputeGraph ... computeGraphs) {
        return this.getTaskExecutor().plan(computeGraphs);
    }
}

