/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.cdfw;

import com.google.protobuf.Any;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.common.driver.IDriverMessenger;
import edu.iu.dsc.tws.common.driver.IScaler;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.task.cdfw.CDFWExecutor;
import edu.iu.dsc.tws.task.cdfw.DataFlowGraph;
import java.util.List;
import java.util.logging.Logger;

public class CDFWEnv {
    private static final Logger LOG = Logger.getLogger(CDFWEnv.class.getName());
    private CDFWExecutor cdfwExecutor;
    private IScaler resourceScaler;
    private Config config;
    private volatile List<JobMasterAPI.WorkerInfo> workerInfoList;

    public CDFWEnv(Config config, IScaler resourceScaler, IDriverMessenger driverMessenger, List<JobMasterAPI.WorkerInfo> workers) {
        this.resourceScaler = resourceScaler;
        this.config = config;
        this.workerInfoList = workers;
        this.cdfwExecutor = new CDFWExecutor(this, driverMessenger);
    }

    public Config getConfig() {
        return this.config;
    }

    public void executeDataFlowGraph(DataFlowGraph dataFlowGraph) {
        this.cdfwExecutor.execute(dataFlowGraph);
    }

    public void increaseWorkers(int workers) {
        this.resourceScaler.scaleUpWorkers(workers);
    }

    public void decreaseWorkers(int workers) {
        this.resourceScaler.scaleDownWorkers(workers);
    }

    public List<JobMasterAPI.WorkerInfo> getWorkerInfoList() {
        return this.workerInfoList;
    }

    public void workerMessageReceived(Any anyMessage, int senderWorkerID) {
        this.cdfwExecutor.workerMessageReceived(anyMessage, senderWorkerID);
    }

    public void allWorkersJoined(List<JobMasterAPI.WorkerInfo> workerList) {
        this.workerInfoList = workerList;
    }

    public void close() {
        this.cdfwExecutor.close();
    }
}

