/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.cdfw;

import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.task.cdfw.DataFlowGraph;
import edu.iu.dsc.tws.task.cdfw.ICDFWScheduler;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class DefaultScheduler
implements ICDFWScheduler {
    private static final Logger LOG = Logger.getLogger(DefaultScheduler.class.getName());
    private List<JobMasterAPI.WorkerInfo> workerInfoList;
    private static Map<DataFlowGraph, Set<Integer>> scheduledGraphMap = new LinkedHashMap<DataFlowGraph, Set<Integer>>();

    protected DefaultScheduler(List<JobMasterAPI.WorkerInfo> workerInfoList) {
        this.workerInfoList = workerInfoList;
    }

    @Override
    public Set<Integer> schedule(DataFlowGraph graphJob) {
        Set<Integer> scheduledGraph = this.scheduleGraphs(graphJob);
        LOG.info("%%%% Scheduled Graph list details: %%%%" + scheduledGraph);
        return scheduledGraph;
    }

    @Override
    public Map<DataFlowGraph, Set<Integer>> schedule(DataFlowGraph ... graphJob) {
        if (graphJob.length == 1) {
            LOG.info("Graph Resource Requirements:" + graphJob[0].getWorkers());
            Set<Integer> workerList = this.scheduleGraphs(graphJob[0]);
            scheduledGraphMap.put(graphJob[0], workerList);
        } else if (graphJob.length > 1) {
            LOG.info("Graph Resource Requirements:" + graphJob[0].getWorkers() + "\t" + graphJob[1].getWorkers());
            for (DataFlowGraph graph : graphJob) {
                Set<Integer> workerList = this.scheduleGraphs(graph);
                scheduledGraphMap.put(graph, workerList);
            }
            LOG.info("Graph Resource Requirements:" + graphJob[0].getWorkers() + "\t" + graphJob[1].getWorkers() + "\t" + this.workerInfoList.size() + "%%%% Scheduled Graph Map details: %%%%" + scheduledGraphMap);
        }
        return scheduledGraphMap;
    }

    private Set<Integer> scheduleGraphs(DataFlowGraph graph) {
        HashSet<Integer> workerList = new HashSet<Integer>();
        if (this.workerInfoList.size() == graph.getWorkers()) {
            for (JobMasterAPI.WorkerInfo workerInfos : this.workerInfoList) {
                workerList.add(workerInfos.getWorkerID());
            }
        } else if (this.workerInfoList.size() > graph.getWorkers()) {
            for (JobMasterAPI.WorkerInfo workerInfos : this.workerInfoList) {
                IntStream.range(0, graph.getWorkers()).mapToObj(i -> workerInfos.getWorkerID()).forEachOrdered(workerList::add);
                if (workerList.size() != graph.getWorkers()) continue;
                break;
            }
        } else {
            throw new RuntimeException("Insufficient resources to run the dataflow graph");
        }
        return workerList;
    }
}

