/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.dataobjects;

import edu.iu.dsc.tws.api.compute.IMessage;
import edu.iu.dsc.tws.api.compute.TaskContext;
import edu.iu.dsc.tws.api.compute.modifiers.Collector;
import edu.iu.dsc.tws.api.compute.nodes.BaseSink;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.api.dataset.DataPartition;
import edu.iu.dsc.tws.data.api.OutputWriter;
import edu.iu.dsc.tws.data.api.out.TextOutputWriter;
import edu.iu.dsc.tws.dataset.DataSink;
import edu.iu.dsc.tws.dataset.partition.EntityPartition;
import java.util.logging.Logger;

public class DataFileSink<T>
extends BaseSink
implements Collector {
    private static final Logger LOG = Logger.getLogger(DataFileSink.class.getName());
    private static final long serialVersionUID = -1L;
    private DataSink<String> datasink = null;

    public boolean execute(IMessage message) {
        this.datasink.add(this.context.taskIndex(), (Object)String.valueOf(message.getContent()));
        this.datasink.persist();
        return true;
    }

    public void prepare(Config cfg, TaskContext context) {
        super.prepare(cfg, context);
        String outDir = cfg.getStringValue("output");
        this.datasink = new DataSink(cfg, (OutputWriter)new TextOutputWriter(FileSystem.WriteMode.OVERWRITE, new Path(outDir)));
    }

    public DataPartition<Object> get() {
        return new EntityPartition(this.context.taskIndex(), this.datasink);
    }
}

