/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.graph;

import edu.iu.dsc.tws.api.comms.messaging.types.MessageType;
import edu.iu.dsc.tws.api.compute.IFunction;
import edu.iu.dsc.tws.api.compute.TaskPartitioner;
import edu.iu.dsc.tws.api.compute.graph.ComputeGraph;
import edu.iu.dsc.tws.api.compute.graph.Edge;
import edu.iu.dsc.tws.api.compute.graph.OperationMode;
import edu.iu.dsc.tws.api.compute.graph.Vertex;
import edu.iu.dsc.tws.api.compute.nodes.ICompute;
import edu.iu.dsc.tws.api.compute.nodes.INode;
import edu.iu.dsc.tws.api.compute.nodes.ISink;
import edu.iu.dsc.tws.api.compute.nodes.ISource;

public final class GraphBuilder {
    private ComputeGraph graph = new ComputeGraph();

    private GraphBuilder() {
    }

    public static GraphBuilder newBuilder() {
        return new GraphBuilder();
    }

    public GraphBuilder addSource(String name, ISource source) {
        this.graph.addTaskVertex(name, new Vertex(name, (INode)source));
        return this;
    }

    public GraphBuilder addSource(String name, ISource source, int parallelism) {
        return this.addSource(name, source).setParallelism(name, parallelism);
    }

    public GraphBuilder addSink(String name, ISink sink) {
        this.graph.addTaskVertex(name, new Vertex(name, (INode)sink));
        return this;
    }

    public GraphBuilder addSink(String name, ISink sink, int parallelism) {
        return this.addSink(name, sink).setParallelism(name, parallelism);
    }

    public GraphBuilder addTask(String name, ICompute task) {
        this.graph.addTaskVertex(name, new Vertex(name, (INode)task));
        return this;
    }

    public GraphBuilder addTask(String name, ICompute task, int parallelism) {
        return this.addTask(name, task).setParallelism(name, parallelism);
    }

    public GraphBuilder setParallelism(String taskName, int parallel) {
        Vertex v = this.graph.vertex(taskName);
        if (v == null) {
            throw new RuntimeException("Failed to add configuration to non-existing task: " + taskName);
        }
        v.setParallelism(parallel);
        return this;
    }

    public GraphBuilder addConfiguration(String taskName, String property, Object value) {
        Vertex v = this.graph.vertex(taskName);
        if (v == null) {
            throw new RuntimeException("Failed to add configuration to non-existing task: " + taskName);
        }
        v.addConfiguration(property, value);
        return this;
    }

    public GraphBuilder connect(String t1, String t2, String name, String operation) {
        this.connect(t1, t2, new Edge(name, operation));
        return this;
    }

    public GraphBuilder connect(String t1, String t2, String name, String operation, IFunction task) {
        this.connect(t1, t2, new Edge(name, operation, task));
        return this;
    }

    public GraphBuilder connect(String t1, String t2, String name, String operation, MessageType dataType, MessageType keyType) {
        this.connect(t1, t2, new Edge(name, operation, dataType, keyType));
        return this;
    }

    public GraphBuilder connect(String t1, String t2, String name, String operation, IFunction function, MessageType dataType, MessageType keyType) {
        this.connect(t1, t2, new Edge(name, operation, dataType, keyType, function));
        return this;
    }

    public GraphBuilder connect(String t1, String t2, String name, String operation, IFunction function, MessageType dataType, MessageType keyType, TaskPartitioner partitioner) {
        this.connect(t1, t2, new Edge(name, operation, dataType, keyType, function, partitioner));
        return this;
    }

    public GraphBuilder connect(String t1, String t2, String name, String operation, MessageType dataType) {
        this.connect(t1, t2, new Edge(name, operation, dataType));
        return this;
    }

    public GraphBuilder connect(String t1, String t2, Edge edge) {
        Vertex v1 = this.graph.vertex(t1);
        if (v1 == null) {
            throw new RuntimeException("Failed to connect non-existing task: " + t1);
        }
        Vertex v2 = this.graph.vertex(t2);
        if (v2 == null) {
            throw new RuntimeException("Failed to connect non-existing task: " + t2);
        }
        this.graph.addTaskEdge((Object)v1, (Object)v2, (Object)edge);
        return this;
    }

    public ComputeGraph build() {
        this.graph.validate();
        this.graph.build();
        return this.graph;
    }

    public ComputeGraph operationMode(OperationMode mode) {
        this.graph.setOperationMode(mode);
        return this.graph;
    }

    public boolean vertexExists(String name) {
        return this.graph.vertex(name) != null;
    }
}

