/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl;

import edu.iu.dsc.tws.api.comms.CommunicationContext;
import edu.iu.dsc.tws.api.compute.graph.ComputeGraph;
import edu.iu.dsc.tws.api.compute.graph.Edge;
import edu.iu.dsc.tws.api.compute.graph.Vertex;
import edu.iu.dsc.tws.task.impl.ops.AbstractOpsConfig;
import edu.iu.dsc.tws.task.impl.ops.AllGatherConfig;
import edu.iu.dsc.tws.task.impl.ops.AllReduceConfig;
import edu.iu.dsc.tws.task.impl.ops.BroadcastConfig;
import edu.iu.dsc.tws.task.impl.ops.DirectConfig;
import edu.iu.dsc.tws.task.impl.ops.GatherConfig;
import edu.iu.dsc.tws.task.impl.ops.JoinConfig;
import edu.iu.dsc.tws.task.impl.ops.KeyedGatherConfig;
import edu.iu.dsc.tws.task.impl.ops.KeyedPartitionConfig;
import edu.iu.dsc.tws.task.impl.ops.KeyedReduceConfig;
import edu.iu.dsc.tws.task.impl.ops.PartitionConfig;
import edu.iu.dsc.tws.task.impl.ops.ReduceConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ComputeConnection {
    private String nodeName;
    private Map<String, Map<String, Edge>> inputs = new HashMap<String, Map<String, Edge>>();
    private Map<String, Set<AbstractOpsConfig>> autoConnectConfig = new HashMap<String, Set<AbstractOpsConfig>>();

    ComputeConnection(String nodeName) {
        this.nodeName = nodeName;
    }

    void putEdgeFromSource(String source, Edge edge) {
        Map edgesFromSource = this.inputs.computeIfAbsent(source, s -> new HashMap());
        if (edgesFromSource.containsKey(edge.getName())) {
            throw new RuntimeException("Edges from the same source should be unique. Found " + edge.getName() + " already defined from source " + source);
        }
        edgesFromSource.put(edge.getName(), edge);
    }

    private void addToAutoConfig(String source, AbstractOpsConfig config) {
        this.autoConnectConfig.computeIfAbsent(source, s -> new HashSet()).add(config);
    }

    public BroadcastConfig broadcast(String source) {
        BroadcastConfig broadcastConfig = new BroadcastConfig(source, this);
        this.addToAutoConfig(source, broadcastConfig);
        return broadcastConfig;
    }

    public ReduceConfig reduce(String source) {
        ReduceConfig reduceConfig = new ReduceConfig(source, this);
        this.addToAutoConfig(source, reduceConfig);
        return reduceConfig;
    }

    public KeyedReduceConfig keyedReduce(String source) {
        KeyedReduceConfig keyedReduceConfig = new KeyedReduceConfig(source, this);
        this.addToAutoConfig(source, keyedReduceConfig);
        return keyedReduceConfig;
    }

    public GatherConfig gather(String source) {
        GatherConfig gatherConfig = new GatherConfig(source, this);
        this.addToAutoConfig(source, gatherConfig);
        return gatherConfig;
    }

    public KeyedGatherConfig keyedGather(String source) {
        KeyedGatherConfig keyedGatherConfig = new KeyedGatherConfig(source, this);
        this.addToAutoConfig(source, keyedGatherConfig);
        return keyedGatherConfig;
    }

    public JoinConfig innerJoin(String leftSource, String rightSource) {
        JoinConfig joinConfig = new JoinConfig(leftSource, rightSource, this, CommunicationContext.JoinType.INNER);
        this.addToAutoConfig(leftSource, joinConfig);
        return joinConfig;
    }

    public JoinConfig fullOuterJoin(String leftSource, String rightSource) {
        JoinConfig joinConfig = new JoinConfig(leftSource, rightSource, this, CommunicationContext.JoinType.FULL_OUTER);
        this.addToAutoConfig(leftSource, joinConfig);
        return joinConfig;
    }

    public JoinConfig leftOuterJoin(String leftSource, String rightSource) {
        JoinConfig joinConfig = new JoinConfig(leftSource, rightSource, this, CommunicationContext.JoinType.LEFT);
        this.addToAutoConfig(leftSource, joinConfig);
        return joinConfig;
    }

    public JoinConfig rightOuterJoin(String leftSource, String rightSource) {
        JoinConfig joinConfig = new JoinConfig(leftSource, rightSource, this, CommunicationContext.JoinType.RIGHT);
        this.addToAutoConfig(leftSource, joinConfig);
        return joinConfig;
    }

    public PartitionConfig partition(String source) {
        PartitionConfig partitionConfig = new PartitionConfig(source, this);
        this.addToAutoConfig(source, partitionConfig);
        return partitionConfig;
    }

    public KeyedPartitionConfig keyedPartition(String source) {
        KeyedPartitionConfig keyedPartitionConfig = new KeyedPartitionConfig(source, this);
        this.addToAutoConfig(source, keyedPartitionConfig);
        return keyedPartitionConfig;
    }

    public AllReduceConfig allreduce(String source) {
        AllReduceConfig allReduceConfig = new AllReduceConfig(source, this);
        this.addToAutoConfig(source, allReduceConfig);
        return allReduceConfig;
    }

    public AllGatherConfig allgather(String source) {
        AllGatherConfig allGatherConfig = new AllGatherConfig(source, this);
        this.addToAutoConfig(source, allGatherConfig);
        return allGatherConfig;
    }

    public DirectConfig direct(String source) {
        DirectConfig directConfig = new DirectConfig(source, this);
        this.addToAutoConfig(source, directConfig);
        return directConfig;
    }

    private void doAutoConnect() {
        this.autoConnectConfig.forEach((source, configs) -> configs.forEach(abstractOpsConfig -> {
            if (!this.inputs.containsKey(source) || !this.inputs.get(source).containsKey(abstractOpsConfig.getEdgeName())) {
                abstractOpsConfig.connect();
            }
        }));
        this.autoConnectConfig.clear();
    }

    void build(ComputeGraph graph) {
        this.doAutoConnect();
        this.inputs.forEach((source, edges) -> edges.forEach((edgeName, edge) -> {
            Vertex v1 = graph.vertex(this.nodeName);
            if (v1 == null) {
                throw new RuntimeException("Failed to connect non-existing task: " + this.nodeName);
            }
            Vertex v2 = graph.vertex(source);
            if (v2 == null) {
                throw new RuntimeException("Failed to connect non-existing task: " + source);
            }
            graph.addTaskEdge((Object)v2, (Object)v1, edge);
        }));
    }
}

