/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl;

import edu.iu.dsc.tws.api.compute.graph.ComputeGraph;
import edu.iu.dsc.tws.api.compute.graph.OperationMode;
import edu.iu.dsc.tws.api.compute.graph.Vertex;
import edu.iu.dsc.tws.api.compute.nodes.ICompute;
import edu.iu.dsc.tws.api.compute.nodes.INode;
import edu.iu.dsc.tws.api.compute.nodes.ISink;
import edu.iu.dsc.tws.api.compute.nodes.ISource;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.task.impl.ComputeConnection;
import edu.iu.dsc.tws.task.impl.SourceConnection;
import edu.iu.dsc.tws.task.impl.TaskConfigurations;
import edu.iu.dsc.tws.task.window.api.IWindowedSink;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class ComputeGraphBuilder {
    private static final Logger LOG = Logger.getLogger(ComputeGraphBuilder.class.getName());
    private Map<String, Vertex> nodes = new LinkedHashMap<String, Vertex>();
    private List<ComputeConnection> computeConnections = new ArrayList<ComputeConnection>();
    private List<SourceConnection> sourceConnections = new ArrayList<SourceConnection>();
    private int defaultParallelism;
    private OperationMode mode = OperationMode.STREAMING;
    private String taskGraphName = "unnamed";
    private Map<String, String> graphConstraints = new HashMap<String, String>();
    private Map<String, Map<String, String>> nodeConstraints = new HashMap<String, Map<String, String>>();

    public static ComputeGraphBuilder newBuilder(Config cfg) {
        return new ComputeGraphBuilder(cfg);
    }

    private ComputeGraphBuilder(Config cfg) {
        this.defaultParallelism = TaskConfigurations.getDefaultParallelism(cfg, 1);
    }

    public void setMode(OperationMode mode) {
        this.mode = mode;
    }

    public void setTaskGraphName(String taskGraphName) {
        this.taskGraphName = taskGraphName;
    }

    public ComputeConnection addSink(String name, ISink sink) {
        Vertex vertex = new Vertex(name, (INode)sink, this.defaultParallelism);
        this.nodes.put(name, vertex);
        return this.createComputeConnection(name);
    }

    public ComputeConnection addSink(String name, ISink sink, int parallel) {
        Vertex vertex = new Vertex(name, (INode)sink, parallel);
        this.nodes.put(name, vertex);
        return this.createComputeConnection(name);
    }

    public ComputeConnection addSink(String name, IWindowedSink sink, int parallel) {
        Vertex vertex = new Vertex(name, (INode)sink, parallel);
        this.nodes.put(name, vertex);
        return this.createComputeConnection(name);
    }

    public ComputeConnection addCompute(String name, ICompute compute) {
        Vertex vertex = new Vertex(name, (INode)compute, this.defaultParallelism);
        this.nodes.put(name, vertex);
        return this.createComputeConnection(name);
    }

    public ComputeConnection addCompute(String name, ICompute compute, int parallel) {
        Vertex vertex = new Vertex(name, (INode)compute, parallel);
        this.nodes.put(name, vertex);
        return this.createComputeConnection(name);
    }

    private ComputeConnection createComputeConnection(String name) {
        ComputeConnection cc = new ComputeConnection(name);
        this.computeConnections.add(cc);
        return cc;
    }

    public SourceConnection addSource(String name, ISource source) {
        Vertex vertex = new Vertex(name, (INode)source, this.defaultParallelism);
        this.nodes.put(name, vertex);
        return this.createSourceConnection(name);
    }

    public SourceConnection addSource(String name, ISource source, int parallel) {
        Vertex vertex = new Vertex(name, (INode)source, parallel);
        this.nodes.put(name, vertex);
        return this.createSourceConnection(name);
    }

    private SourceConnection createSourceConnection(String name) {
        SourceConnection sc = new SourceConnection(name);
        this.sourceConnections.add(sc);
        return sc;
    }

    public OperationMode getMode() {
        return this.mode;
    }

    public Map<String, String> addGraphConstraints(String constraintName, String constraintValue) {
        this.graphConstraints.put(constraintName, constraintValue);
        return this.graphConstraints;
    }

    public Map<String, String> addGraphConstraints(Map<String, String> graphconstraints) {
        this.graphConstraints = graphconstraints;
        return this.graphConstraints;
    }

    public Map<String, Map<String, String>> addNodeConstraints(String nodeName, Map<String, String> nodeconstraints) {
        this.nodeConstraints.put(nodeName, nodeconstraints);
        return this.nodeConstraints;
    }

    public ComputeGraph build() {
        ComputeGraph graph = new ComputeGraph();
        graph.setOperationMode(this.mode);
        graph.setGraphName(this.taskGraphName);
        graph.addGraphConstraints(this.graphConstraints);
        graph.addNodeConstraints(this.nodeConstraints);
        for (Map.Entry<String, Vertex> entry : this.nodes.entrySet()) {
            graph.addTaskVertex(entry.getKey(), entry.getValue());
        }
        for (ComputeConnection computeConnection : this.computeConnections) {
            computeConnection.build(graph);
        }
        for (SourceConnection sourceConnection : this.sourceConnections) {
            sourceConnection.build(graph);
        }
        return graph;
    }
}

