/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl.cdfw;

import edu.iu.dsc.tws.api.comms.Communicator;
import edu.iu.dsc.tws.api.comms.channel.TWSChannel;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.TimeoutException;
import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import edu.iu.dsc.tws.api.resource.IVolatileVolume;
import edu.iu.dsc.tws.api.resource.IWorker;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.resource.JobListener;
import edu.iu.dsc.tws.api.resource.Network;
import edu.iu.dsc.tws.master.worker.JMWorkerAgent;
import edu.iu.dsc.tws.task.impl.cdfw.CDFWRuntime;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CDFWWorker
implements IWorker {
    private static final Logger LOG = Logger.getLogger(CDFWWorker.class.getName());
    protected TWSChannel channel;
    protected Communicator communicator;
    protected int workerId;
    protected IWorkerController workerController;
    protected IPersistentVolume persistentVolume;
    protected IVolatileVolume volatileVolume;
    protected Config config;
    protected CDFWRuntime taskExecutor;

    public void execute(Config cfg, int workerID, IWorkerController wController, IPersistentVolume pVolume, IVolatileVolume vVolume) {
        List workerInfoList;
        this.config = cfg;
        this.workerId = workerID;
        this.workerController = wController;
        this.persistentVolume = pVolume;
        this.volatileVolume = vVolume;
        try {
            workerInfoList = wController.getAllWorkers();
        }
        catch (TimeoutException timeoutException) {
            LOG.log(Level.SEVERE, timeoutException.getMessage(), timeoutException);
            return;
        }
        this.channel = Network.initializeChannel((Config)this.config, (IWorkerController)this.workerController);
        String persistent = null;
        if (vVolume != null && vVolume.getWorkerDirPath() != null) {
            persistent = vVolume.getWorkerDirPath();
        }
        this.communicator = new Communicator(this.config, this.channel, persistent);
        this.taskExecutor = new CDFWRuntime(this.config, this.workerId, workerInfoList, this.communicator);
        JMWorkerAgent.addJobListener((JobListener)this.taskExecutor);
        this.execute();
        try {
            this.workerController.waitOnBarrier();
        }
        catch (TimeoutException timeoutException) {
            LOG.log(Level.SEVERE, timeoutException.getMessage(), timeoutException);
        }
        this.communicator.close();
    }

    public void execute() {
        this.taskExecutor.execute();
    }
}

