/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl.ops;

import edu.iu.dsc.tws.api.comms.CommunicationContext;
import edu.iu.dsc.tws.api.comms.messaging.types.MessageType;
import edu.iu.dsc.tws.api.comms.messaging.types.MessageTypes;
import edu.iu.dsc.tws.api.comms.packing.MessageSchema;
import edu.iu.dsc.tws.api.compute.graph.Edge;
import edu.iu.dsc.tws.task.impl.ComputeConnection;
import edu.iu.dsc.tws.task.impl.ComputeConnectionUtils;
import edu.iu.dsc.tws.task.impl.ops.AbstractKeyedOpsConfig;
import java.util.Comparator;

public class JoinConfig
extends AbstractKeyedOpsConfig<JoinConfig> {
    private Comparator keyCompartor;
    private String rightSource;
    private String rightEdgeName;
    private MessageType rightOpDataType = MessageTypes.OBJECT;
    private String group;
    private MessageSchema leftMessageSchema = MessageSchema.noSchema();
    private MessageSchema rightMessageSchema = MessageSchema.noSchema();

    public JoinConfig(String leftParent, String rightParent, ComputeConnection computeConnection, CommunicationContext.JoinType joinType) {
        super(leftParent, "join", computeConnection);
        this.rightSource = rightParent;
        this.withProperty("use-disk", false);
        this.withProperty("join-type", joinType);
    }

    public JoinConfig useDisk(boolean useDisk) {
        return (JoinConfig)this.withProperty("use-disk", useDisk);
    }

    public <T> JoinConfig withComparator(Comparator<T> keyComparator) {
        this.keyCompartor = keyComparator;
        return (JoinConfig)this.withProperty("key-comparator", keyComparator);
    }

    public JoinConfig viaLeftEdge(String edge) {
        this.edgeName = edge;
        return this;
    }

    public JoinConfig viaRightEdge(String edge) {
        this.rightEdgeName = edge;
        return this;
    }

    public JoinConfig withRightDataType(MessageType dataType) {
        this.rightOpDataType = dataType;
        return this;
    }

    public JoinConfig withLeftDataType(MessageType dataType) {
        this.opDataType = dataType;
        return this;
    }

    @Override
    public JoinConfig withMessageSchema(MessageSchema messageSchema) {
        this.leftMessageSchema = messageSchema;
        this.rightMessageSchema = messageSchema;
        return this;
    }

    public JoinConfig withLeftMessageSchema(MessageSchema messageSchema) {
        this.leftMessageSchema = messageSchema;
        return this;
    }

    public JoinConfig withRightMessageSchema(MessageSchema messageSchema) {
        this.rightMessageSchema = messageSchema;
        return this;
    }

    public JoinConfig withTargetEdge(String g) {
        this.group = g;
        return this;
    }

    @Override
    void validate() {
        if (this.keyCompartor == null) {
            JoinConfig.failValidation("Join operation needs a key comparator.");
        }
        if (this.rightEdgeName == null) {
            JoinConfig.failValidation("Right edge should have a name");
        }
    }

    @Override
    public ComputeConnection connect() {
        Edge leftEdge = this.buildEdge();
        leftEdge.setEdgeIndex(0);
        leftEdge.setNumberOfEdges(2);
        leftEdge.setMessageSchema(this.leftMessageSchema);
        Edge rightEdge = this.buildRightEdge();
        rightEdge.setEdgeIndex(1);
        rightEdge.setNumberOfEdges(2);
        rightEdge.setMessageSchema(this.rightMessageSchema);
        if (this.group == null) {
            this.group = this.edgeName + "-" + this.rightEdgeName + "-" + this.source + "-" + this.rightSource;
        }
        leftEdge.setTargetEdge(this.group);
        rightEdge.setTargetEdge(this.group);
        ComputeConnectionUtils.connectEdge(this.computeConnection, this.source, leftEdge);
        ComputeConnectionUtils.connectEdge(this.computeConnection, this.rightSource, rightEdge);
        return this.computeConnection;
    }

    Edge buildRightEdge() {
        this.runValidation();
        Edge edge = new Edge(this.rightEdgeName, this.operationName);
        edge.setDataType(this.rightOpDataType);
        edge.addProperties(this.propertiesMap);
        this.updateEdge(edge);
        edge.setKeyed(true);
        edge.setKeyType(this.opKeyType);
        edge.setPartitioner(this.tPartitioner);
        return edge;
    }

    @Override
    protected Edge updateEdge(Edge newEdge) {
        return newEdge;
    }
}

