/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.impl.ops;

import edu.iu.dsc.tws.api.compute.graph.Edge;
import edu.iu.dsc.tws.task.impl.ComputeConnection;
import edu.iu.dsc.tws.task.impl.ops.AbstractKeyedOpsConfig;
import java.util.Comparator;

public class KeyedGatherConfig
extends AbstractKeyedOpsConfig<KeyedGatherConfig> {
    private boolean useDsk;
    private Comparator keyCompartor;
    private boolean grpByKey = true;
    private boolean srtByKey;

    public KeyedGatherConfig(String parent, ComputeConnection computeConnection) {
        super(parent, "keyed_gather", computeConnection);
    }

    public KeyedGatherConfig useDisk(boolean useDisk) {
        this.useDsk = useDisk;
        return (KeyedGatherConfig)this.withProperty("use-disk", useDisk);
    }

    public <T> KeyedGatherConfig sortBatchByKey(boolean sortByKey, Comparator<T> keyComparator) {
        this.srtByKey = sortByKey;
        this.keyCompartor = keyComparator;
        return (KeyedGatherConfig)((KeyedGatherConfig)this.withProperty("sort-by-key", sortByKey)).withProperty("key-comparator", keyComparator);
    }

    public <T> KeyedGatherConfig sortBatchByKey(boolean sortByKey, Class<T> tClass, Comparator<T> keyComparator) {
        this.srtByKey = sortByKey;
        this.keyCompartor = keyComparator;
        return (KeyedGatherConfig)((KeyedGatherConfig)this.withProperty("sort-by-key", sortByKey)).withProperty("key-comparator", keyComparator);
    }

    public KeyedGatherConfig groupBatchByKey(boolean groupByKey) {
        this.grpByKey = groupByKey;
        return (KeyedGatherConfig)this.withProperty("group-by-key", groupByKey);
    }

    @Override
    void validate() {
        if (this.srtByKey && this.keyCompartor == null) {
            KeyedGatherConfig.failValidation("KeyedGather operation configured to sort by key. But Key Comparator is not specified.");
        }
    }

    @Override
    protected Edge updateEdge(Edge newEdge) {
        if (this.keyCompartor != null) {
            newEdge.addProperty("key-comparator", (Object)this.keyCompartor);
        }
        newEdge.addProperty("sort-by-key", (Object)this.srtByKey);
        newEdge.addProperty("group-by-key", (Object)this.grpByKey);
        return newEdge;
    }
}

