/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.collectives;

import edu.iu.dsc.tws.api.compute.IMessage;
import edu.iu.dsc.tws.task.window.api.IWindowMessage;
import edu.iu.dsc.tws.task.window.core.BaseWindowedSink;
import edu.iu.dsc.tws.task.window.function.AggregateWindowedFunction;

public abstract class AggregateWindow<T>
extends BaseWindowedSink<T> {
    private AggregateWindowedFunction<T> aggregateWindowedFunction;

    public abstract boolean aggregate(T var1);

    public abstract boolean aggregateLateMessages(T var1);

    public AggregateWindow(AggregateWindowedFunction aggregateWindowedFunction) {
        this.aggregateWindowedFunction = aggregateWindowedFunction;
    }

    @Override
    public boolean execute(IWindowMessage<T> windowMessage) {
        if (windowMessage != null) {
            Object current = null;
            for (IMessage<T> msg : windowMessage.getWindow()) {
                Object value = msg.getContent();
                if (current == null) {
                    current = value;
                    continue;
                }
                current = this.aggregateWindowedFunction.onMessage(current, value);
            }
            this.aggregate(current);
        }
        return true;
    }

    @Override
    public boolean getLateMessages(IMessage<T> lateMessages) {
        return this.aggregateLateMessages(lateMessages.getContent());
    }

    @Override
    public boolean getExpire(IWindowMessage<T> expiredMessages) {
        return false;
    }
}

