/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.policy.eviction.count;

import edu.iu.dsc.tws.task.window.api.Event;
import edu.iu.dsc.tws.task.window.api.IEvictionContext;
import edu.iu.dsc.tws.task.window.api.IEvictionPolicy;
import edu.iu.dsc.tws.task.window.constant.Action;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class CountEvictionPolicy<T>
implements IEvictionPolicy<T> {
    private static final Logger LOG = Logger.getLogger(CountEvictionPolicy.class.getName());
    protected final long threshold;
    protected final AtomicLong currentCount;

    public CountEvictionPolicy(long count) {
        this.threshold = count;
        this.currentCount = new AtomicLong();
    }

    @Override
    public Action evict(Event<T> event) {
        long curVal;
        while ((curVal = this.currentCount.get()) > this.threshold) {
            if (!this.currentCount.compareAndSet(curVal, curVal - 1L)) continue;
            return Action.EXPIRE;
        }
        return Action.PROCESS;
    }

    @Override
    public void track(Event<T> event) {
        if (!event.isWatermark()) {
            this.currentCount.incrementAndGet();
        }
    }

    @Override
    public void setContext(IEvictionContext context) {
    }

    public String toString() {
        return "CountEvictionPolicy{threshold=" + this.threshold + ", currentCount=" + this.currentCount + '}';
    }
}

