/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.policy.eviction.count;

import edu.iu.dsc.tws.task.window.api.Event;
import edu.iu.dsc.tws.task.window.api.IEvictionContext;
import edu.iu.dsc.tws.task.window.constant.Action;
import edu.iu.dsc.tws.task.window.policy.eviction.count.CountEvictionPolicy;

public class WatermarkCountEvictionPolicy<T>
extends CountEvictionPolicy<T> {
    private long referenceTime = 0L;
    private long processedCount = 0L;
    private IEvictionContext evictionContext;

    public WatermarkCountEvictionPolicy(long count) {
        super(count);
    }

    @Override
    public Action evict(Event<T> event) {
        Action action;
        if (this.evictionContext == null) {
            return Action.STOP;
        }
        if (event.getTimeStamp() <= this.referenceTime && this.processedCount < this.currentCount.get()) {
            action = super.evict(event);
            if (action == Action.PROCESS) {
                ++this.processedCount;
            }
        } else {
            action = Action.KEEP;
        }
        return action;
    }

    @Override
    public void track(Event<T> event) {
    }

    @Override
    public void setContext(IEvictionContext context) {
        this.evictionContext = context;
        this.referenceTime = context.getReferenceTime();
        if (context.getCurrentCount() != null) {
            this.currentCount.set(context.getCurrentCount());
        } else {
            this.currentCount.set(this.processedCount + context.getSlidingCount());
        }
        this.processedCount = 0L;
    }

    @Override
    public String toString() {
        return "WatermarkCountEvictionPolicy{referenceTime=" + this.referenceTime + ", processedCount=" + this.processedCount + ", evictionContext=" + this.evictionContext + '}' + super.toString();
    }
}

