/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.task.window.util;

import edu.iu.dsc.tws.task.window.config.WindowConfig;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class WindowParameter
implements Serializable {
    private WindowConfig.Count windowCountSize;
    private WindowConfig.Count slidingCountSize;
    private WindowConfig.Duration windowDurationSize;
    private WindowConfig.Duration sldingDurationSize;

    public WindowParameter withTumblingCountWindow(long winLength) {
        return this.withTumblingCountWindowInit(winLength);
    }

    private WindowParameter withTumblingCountWindowInit(long winLength) {
        this.slidingCountSize = this.windowCountSize = this.newCountInstance(winLength);
        return this;
    }

    public WindowParameter withTumblingDurationWindow(long winLength, TimeUnit timeUnit) {
        return this.withTumblingDurationWindowInit(winLength, timeUnit);
    }

    private WindowParameter withTumblingDurationWindowInit(long winLength, TimeUnit timeUnit) {
        this.sldingDurationSize = this.windowDurationSize = this.newDurationInstance(winLength, timeUnit);
        return this;
    }

    public WindowParameter withSlidingingCountWindow(long winLength, long slidingLength) {
        return this.withSlidingCountWindowInit(winLength, slidingLength);
    }

    private WindowParameter withSlidingCountWindowInit(long winLength, long slidingLength) {
        this.windowCountSize = this.newCountInstance(winLength);
        this.slidingCountSize = this.newCountInstance(slidingLength);
        return this;
    }

    public WindowParameter withSlidingDurationWindow(long winLength, TimeUnit winLengthTU, long slidingLength, TimeUnit slidingLengthTU) {
        return this.withSlidingDurationWindowInit(winLength, winLengthTU, slidingLength, slidingLengthTU);
    }

    private WindowParameter withSlidingDurationWindowInit(long winLength, TimeUnit winLengthTU, long slidingLength, TimeUnit slidingLengthTU) {
        this.windowDurationSize = this.newDurationInstance(winLength, winLengthTU);
        this.sldingDurationSize = this.newDurationInstance(slidingLength, slidingLengthTU);
        return this;
    }

    private WindowConfig.Count newCountInstance(long value) {
        return new WindowConfig.Count(value);
    }

    private WindowConfig.Duration newDurationInstance(long value, TimeUnit timeUnit) {
        return new WindowConfig.Duration(value, timeUnit);
    }

    public WindowConfig.Count getWindowCountSize() {
        return this.windowCountSize;
    }

    public WindowConfig.Count getSlidingCountSize() {
        return this.slidingCountSize;
    }

    public WindowConfig.Duration getWindowDurationSize() {
        return this.windowDurationSize;
    }

    public WindowConfig.Duration getSldingDurationSize() {
        return this.sldingDurationSize;
    }
}

