/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.stream.plugin.javascript.api;

import org.voltdb.stream.api.extension.VoltStreamResourceConfigurator;
import org.voltdb.stream.execution.Configuration;
import org.voltdb.stream.plugin.javascript.api.JavaScriptResourceConfig;

public final class JavaScriptResourceConfigBuilder
implements VoltStreamResourceConfigurator {
    public static final String CONFIG_PATH = "javascript-engine";

    public JavaScriptResourceConfigBuilder() {
        this.autoConfigureBuilder();
    }

    public JavaScriptResourceConfigBuilder configure(String path) {
        if (!this.getConfiguration().findByPath(path, new String[0]).hasValue()) {
            throw new IllegalArgumentException("No configuration found for path:" + path);
        }
        this.configureBuilder(this.getConfiguration(), path);
        return this;
    }

    private void autoConfigureBuilder() {
        if (this.getConfiguration() != null && this.getConfiguration().findByPath(CONFIG_PATH, new String[0]).hasValue()) {
            this.configureBuilder(this.getConfiguration(), CONFIG_PATH);
        }
    }

    public JavaScriptResourceConfigBuilder configureBuilder(Configuration configuration) {
        this.configureBuilder(configuration, CONFIG_PATH);
        return this;
    }

    public JavaScriptResourceConfig build() {
        return new JavaScriptResourceConfig();
    }

    private <T extends Enum> T fromString(T[] enums, String path, String value) {
        for (T e : enums) {
            if (!((Enum)e).name().equalsIgnoreCase(value)) continue;
            return e;
        }
        throw new IllegalArgumentException("The value for '" + path + "' is invalid: '" + value + "'");
    }

    public void configureBuilder(Configuration configuration, String path) {
    }

    public static JavaScriptResourceConfigBuilder builder() {
        return new JavaScriptResourceConfigBuilder();
    }
}

