/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.stream.plugin.javascript.api;

import java.net.URI;
import org.voltdb.stream.api.extension.VoltStreamFunctionConfigurator;
import org.voltdb.stream.execution.Configuration;
import org.voltdb.stream.plugin.javascript.api.JavaScriptProcessorConfig;

public final class JavaScriptProcessorConfigBuilder<T>
implements VoltStreamFunctionConfigurator<T, Object> {
    public static final String CONFIG_PATH = "processor.javascript";
    private String script;
    private URI scriptUrl;

    public JavaScriptProcessorConfigBuilder() {
        this.autoConfigureBuilder();
    }

    public JavaScriptProcessorConfigBuilder<T> configure(String path) {
        if (!this.getConfiguration().findByPath(path, new String[0]).hasValue()) {
            throw new IllegalArgumentException("No configuration found for path:" + path);
        }
        this.configureBuilder(this.getConfiguration(), path);
        return this;
    }

    private void autoConfigureBuilder() {
        if (this.getConfiguration() != null && this.getConfiguration().findByPath(CONFIG_PATH, new String[0]).hasValue()) {
            this.configureBuilder(this.getConfiguration(), CONFIG_PATH);
        }
    }

    public JavaScriptProcessorConfig build() {
        return new JavaScriptProcessorConfig(this.script, this.scriptUrl);
    }

    public JavaScriptProcessorConfigBuilder<T> withScript(String script) {
        this.script = script;
        return this;
    }

    public JavaScriptProcessorConfigBuilder<T> withScriptUrl(URI scriptUrl) {
        this.scriptUrl = scriptUrl;
        return this;
    }

    public JavaScriptProcessorConfigBuilder<T> withScriptUrl(String path) {
        this.scriptUrl = URI.create(path);
        return this;
    }

    private <T extends Enum> T fromString(T[] enums, String path, String value) {
        for (T e : enums) {
            if (!((Enum)e).name().equalsIgnoreCase(value)) continue;
            return e;
        }
        throw new IllegalArgumentException("The value for '" + path + "' is invalid: '" + value + "'");
    }

    public void configureBuilder(Configuration configuration, String path) {
        Configuration.ConfigurationPart part = configuration.findByPath(path, new String[]{"script"});
        if (part.hasValue()) {
            this.script = part.asString();
        }
        if ((part = configuration.findByPath(path, new String[]{"scriptUrl"})).hasValue()) {
            this.scriptUrl = URI.create(part.asString());
        }
    }

    public static <T> JavaScriptProcessorConfigBuilder<T> builder() {
        return new JavaScriptProcessorConfigBuilder<T>();
    }
}

