/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.documentation.examples;

import java.util.HashMap;
import java.util.Map;
import org.webpieces.router.api.extensions.ObjectStringConverter;

public enum ColorEnum {
    WHITE("White", "white"),
    BLUE("Blue", "blue"),
    RED("Red", "red"),
    GREEN("Green", "green");

    private String label;
    private String databaseCode;
    private static Map<String, ColorEnum> lookupColor;

    private ColorEnum(String label, String databaseCode) {
        this.label = label;
        this.databaseCode = databaseCode;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDatabaseCode() {
        return this.databaseCode;
    }

    public static ColorEnum lookupByCode(String code) {
        return lookupColor.get(code);
    }

    static {
        lookupColor = new HashMap<String, ColorEnum>();
        for (ColorEnum color : ColorEnum.values()) {
            lookupColor.put(color.databaseCode, color);
        }
    }

    public static class WebConverter
    implements ObjectStringConverter<ColorEnum> {
        public String objectToString(ColorEnum value) {
            if (value == null) {
                return null;
            }
            return value.getDatabaseCode();
        }

        public ColorEnum stringToObject(String value) {
            if (value == null) {
                return null;
            }
            return ColorEnum.lookupByCode(value);
        }

        public Class<ColorEnum> getConverterType() {
            return ColorEnum.class;
        }
    }
}

