/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.documentation.examples;

import org.webpieces.ctx.api.HttpMethod;
import org.webpieces.plugins.documentation.DocumentationConfig;
import org.webpieces.plugins.documentation.examples.ExampleRouteId;
import org.webpieces.router.api.routebldr.DomainRouteBuilder;
import org.webpieces.router.api.routebldr.RouteBuilder;
import org.webpieces.router.api.routebldr.ScopedRouteBuilder;
import org.webpieces.router.api.routes.Port;
import org.webpieces.router.api.routes.RouteId;
import org.webpieces.router.api.routes.Routes;

public class ExampleRoutes
implements Routes {
    private String path;

    public ExampleRoutes(DocumentationConfig config) {
        this.path = config.getPluginPath();
    }

    public void configure(DomainRouteBuilder domainRouteBldr) {
        RouteBuilder baseBldr = domainRouteBldr.getBackendRouteBuilder();
        ScopedRouteBuilder scopedBldr = baseBldr.getScopedRouteBuilder(this.path);
        scopedBldr.addRoute(Port.BOTH, HttpMethod.GET, "/examples/input", "ExamplesController.inputText", (RouteId)ExampleRouteId.INPUT_TEXT);
        scopedBldr.addRoute(Port.BOTH, HttpMethod.POST, "/examples/postInput", "ExamplesController.postInputText", (RouteId)ExampleRouteId.POST_INPUT_TEXT_FORM);
        scopedBldr.addRoute(Port.BOTH, HttpMethod.GET, "/examples/inputResult", "ExamplesController.inputTextResult", (RouteId)ExampleRouteId.INPUT_TEXT_RESULT);
        scopedBldr.addRoute(Port.BOTH, HttpMethod.GET, "/examples/checkbox", "ExamplesController.checkbox", (RouteId)ExampleRouteId.CHECKBOX);
        scopedBldr.addRoute(Port.BOTH, HttpMethod.POST, "/examples/postCheckbox", "ExamplesController.postCheckbox", (RouteId)ExampleRouteId.POST_CHECKBOX);
        scopedBldr.addRoute(Port.BOTH, HttpMethod.GET, "/examples/checkboxResult", "ExamplesController.checkboxResult", (RouteId)ExampleRouteId.CHECKBOX_RESULT);
        scopedBldr.addRoute(Port.BOTH, HttpMethod.GET, "/examples/enumList", "ExamplesController.enumList", (RouteId)ExampleRouteId.ENUM_LIST_SINGLE_SELECT);
        scopedBldr.addRoute(Port.BOTH, HttpMethod.POST, "/examples/postEnumList", "ExamplesController.postEnumList", (RouteId)ExampleRouteId.POST_ENUM_LIST_SINGLE_SELECT);
        scopedBldr.addRoute(Port.BOTH, HttpMethod.GET, "/examples/enumListResult", "ExamplesController.enumListResult", (RouteId)ExampleRouteId.ENUM_LIST_SINGLE_SELECT_RESULT);
    }
}

