/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.documentation.examples;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.webpieces.ctx.api.Current;
import org.webpieces.plugins.backend.menu.MenuCreator;
import org.webpieces.plugins.documentation.examples.ColorEnum;
import org.webpieces.plugins.documentation.examples.ExampleRouteId;
import org.webpieces.router.api.controller.actions.Actions;
import org.webpieces.router.api.controller.actions.Redirect;
import org.webpieces.router.api.controller.actions.Render;
import org.webpieces.router.api.routes.RouteId;

@Singleton
public class ExamplesController {
    private MenuCreator menuCreator;

    @Inject
    public ExamplesController(MenuCreator menuCreator) {
        this.menuCreator = menuCreator;
    }

    public Render inputText() {
        return Actions.renderThis((Object[])new Object[]{"menu", this.menuCreator.getMenu(), "firstName", null});
    }

    public Redirect postInputText(String firstName) {
        Current.flash().put("firstName", (Object)firstName);
        Current.flash().keep();
        return Actions.redirect((RouteId)ExampleRouteId.INPUT_TEXT_RESULT, (Object[])new Object[0]);
    }

    public Render inputTextResult() {
        String firstName = Current.flash().get("firstName");
        return Actions.renderThis((Object[])new Object[]{"menu", this.menuCreator.getMenu(), "firstName", firstName});
    }

    public Render checkbox() {
        return Actions.renderThis((Object[])new Object[]{"menu", this.menuCreator.getMenu(), "fun", true, "another", "checked"});
    }

    public Redirect postCheckbox(String fun) {
        Current.flash().put("isFun", (Object)fun);
        Current.flash().keep();
        return Actions.redirect((RouteId)ExampleRouteId.CHECKBOX_RESULT, (Object[])new Object[0]);
    }

    public Render checkboxResult() {
        String message = "Other webservers are just not as cool";
        String isCool = Current.flash().get("isFun");
        if ("true".equals(isCool)) {
            message = "Webpieces is so cool";
        }
        return Actions.renderThis((Object[])new Object[]{"menu", this.menuCreator.getMenu(), "message", message});
    }

    public Render enumList() {
        List<ColorEnum> colorList = Arrays.asList(ColorEnum.values());
        return Actions.renderThis((Object[])new Object[]{"menu", this.menuCreator.getMenu(), "colors", colorList, "selectedColor", ColorEnum.GREEN});
    }

    public Redirect postEnumList(String selectedColor) {
        Current.flash().put("selectedColor", (Object)selectedColor);
        Current.flash().keep();
        return Actions.redirect((RouteId)ExampleRouteId.ENUM_LIST_SINGLE_SELECT_RESULT, (Object[])new Object[0]);
    }

    public Render enumListResult() {
        String selectedColor = Current.flash().get("selectedColor");
        return Actions.renderThis((Object[])new Object[]{"menu", this.menuCreator.getMenu(), "selectedColor", selectedColor});
    }
}

