/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.IRowNumberOffsetSupplier;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.designer.JavaPropertyNameDesignerAttributeSupport;
import pl.fhframework.core.forms.IterationContext;
import pl.fhframework.core.forms.iterators.IRepeatableIteratorInfo;
import pl.fhframework.core.forms.iterators.ISingleIteratorComponentFactory;
import pl.fhframework.core.forms.iterators.ISingleIteratorRepeatable;
import pl.fhframework.core.forms.iterators.RepeatableIteratorInfo;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.ComponentStateSaver;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IEditableGroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.IRepeatable;
import pl.fhframework.model.forms.IStateHolder;
import pl.fhframework.model.forms.NonVisualFormElement;
import pl.fhframework.model.forms.RepeaterComponentCloner;

@Control(canBeDesigned=true)
@DocumentedComponent(ignoreFields={"width"}, category=DocumentedComponent.Category.ARRANGEMENT, value="Component that allows to arrange data like text, images, links, etc. into rows and columns of cells.", icon="fa fa-sitemap")
public class Repeater
extends FormElement
implements IEditableGroupingComponent<Component>,
IRepeatable,
IStateHolder,
ISingleIteratorRepeatable<Repeater> {
    protected static final IRowNumberOffsetSupplier NO_OFFSET_ROW_NUMBER = () -> 0;
    @JsonIgnore
    private boolean processComponentChange = true;
    @JsonIgnore
    private ISingleIteratorComponentFactory<Repeater> interatorComponentFactory;
    @JsonIgnore
    private List<Component> repeatedComponents = new LinkedList<Component>();
    @JsonIgnore
    private List<IterationContext> bindedSubcomponents = new LinkedList<IterationContext>();
    @JsonIgnore
    @XMLProperty
    @DesignerXMLProperty(commonUse=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, priority=20, support=JavaPropertyNameDesignerAttributeSupport.class)
    @DocumentedComponentAttribute(value="Name of the iterator variable used to refer each data")
    private String iterator;
    @JsonIgnore
    @XMLProperty
    @DesignerXMLProperty(allowedTypes={Collection.class}, commonUse=true, bindingOnly=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, priority=15)
    @DocumentedComponentAttribute(boundable=true, value="Collection of data to be displayed")
    private ModelBinding<?> collection;
    @JsonIgnore
    private ComponentStateSaver componentStateSaver = new ComponentStateSaver();
    @JsonIgnore
    protected RepeaterIterationContext iterationContext = null;
    @JsonIgnore
    private Integer modelRefSize = null;

    public Repeater(Form formatka) {
        super(formatka);
        this.interatorComponentFactory = new RepeaterComponentCloner();
    }

    public void init() {
        super.init();
        for (Component component : this.repeatedComponents) {
            if (component.isInitDone()) continue;
            component.init();
            if (!(component instanceof IGroupingComponent)) continue;
            ((IGroupingComponent)component).doActionForEverySubcomponent(c -> {
                if (!component.isInitDone()) {
                    c.init();
                }
            });
        }
    }

    public List<Component> getSubcomponents() {
        if (this.getForm().getViewMode() == Form.ViewMode.NORMAL) {
            return this.bindedSubcomponents.stream().map(ctx -> ctx.getComponent()).collect(Collectors.toList());
        }
        return this.repeatedComponents;
    }

    public List<NonVisualFormElement> getNonVisualSubcomponents() {
        return Collections.emptyList();
    }

    public IRepeatableIteratorInfo getIteratorInfo() {
        if (this.iterator != null) {
            return new RepeatableIteratorInfo(this.getIterator(), this.getCollection() != null ? this.getCollection().getBindingExpression() : null);
        }
        return null;
    }

    public void addSubcomponent(Component formElement) {
        this.repeatedComponents.add(formElement);
    }

    public void removeSubcomponent(Component removedFormElement) {
        this.repeatedComponents.remove(removedFormElement);
    }

    public void processComponents() {
        if (this.getForm().getViewMode() != Form.ViewMode.NORMAL) {
            return;
        }
        if (this.collection == null) {
            return;
        }
        Collection<?> collectionData = this.getBoundCollection();
        int oldModelRefSize = this.modelRefSize != null ? this.modelRefSize : 0;
        this.modelRefSize = collectionData.size();
        if (oldModelRefSize != this.modelRefSize) {
            LinkedList<IterationContext> newBindedSubcomponents = new LinkedList<IterationContext>();
            for (int index = 0; index < this.modelRefSize; ++index) {
                if (oldModelRefSize > index) {
                    for (IterationContext existingComponent : this.bindedSubcomponents) {
                        if (!existingComponent.getIndex().equals(index)) continue;
                        newBindedSubcomponents.add(existingComponent);
                    }
                    continue;
                }
                List newComponents = this.interatorComponentFactory.createComponentsForIterator((IGroupingComponent)this, NO_OFFSET_ROW_NUMBER, index);
                for (FormElement newComponent : newComponents) {
                    newBindedSubcomponents.add(new IterationContext(Integer.valueOf(index), (Component)newComponent));
                }
            }
            this.bindedSubcomponents.clear();
            this.bindedSubcomponents.addAll(newBindedSubcomponents);
        }
    }

    @JsonIgnore
    public Collection<?> getBoundCollection() {
        BindingResult collectionBinding = this.collection.getBindingResult();
        if (collectionBinding.getValue() == null) {
            return Collections.emptyList();
        }
        if (!Collection.class.isAssignableFrom(collectionBinding.getValue().getClass())) {
            throw new RuntimeException("Not a Collection: " + this.collection.getBindingExpression());
        }
        return (Collection)collectionBinding.getValue();
    }

    protected void postClone(FormElement originalComponent) {
        if (!(this.interatorComponentFactory instanceof RepeaterComponentCloner)) {
            throw new RuntimeException("Cannot clone Repeater with compiled cloner: " + this.interatorComponentFactory.getClass());
        }
    }

    public IGroupingComponent getGroupingComponentForNewComponents() {
        return this;
    }

    protected ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        this.processComponentChange((IGroupingComponent)this, elementChanges);
        return elementChanges;
    }

    public void refreshView(Set<ElementChanges> changeSet) {
        super.refreshView(changeSet);
        this.doActionForEverySubcomponent(component -> {
            if (component instanceof GroupingComponent) {
                component.refreshView(changeSet);
            }
        });
    }

    protected static String remSpecial(String binding) {
        return binding.replace("{", "").replace("}", "");
    }

    public void setProcessComponentStateChange(boolean processComponentChange) {
        this.processComponentChange = processComponentChange;
        this.getRepeatedComponents().stream().forEachOrdered(c -> {
            if (c instanceof IStateHolder) {
                ((IStateHolder)c).setProcessComponentStateChange(processComponentChange);
            }
        });
        this.getSubcomponents().stream().forEachOrdered(c -> {
            if (c instanceof IStateHolder) {
                ((IStateHolder)c).setProcessComponentStateChange(processComponentChange);
            }
        });
    }

    public void processComponentChange(IGroupingComponent groupingComponent, ElementChanges elementChanges) {
        if (this.processComponentChange) {
            this.componentStateSaver.processComponentChange(groupingComponent, elementChanges);
        }
    }

    private String getIterationContextInfo() {
        return (this.iterationContext != null ? " --- [iterationBinding: " + this.iterationContext.getIterationBinding() + "]" : " [iterationContext=null]") + (this.iterationContext != null ? " --- [iterationIterator: " + this.iterationContext.getIterationIterator() + "]" : "") + (this.iterationContext != null ? " --- [iterationIndex: " + this.iterationContext.getIterationIndex() + "]" : "");
    }

    public boolean isProcessComponentChange() {
        return this.processComponentChange;
    }

    public void setInteratorComponentFactory(ISingleIteratorComponentFactory<Repeater> interatorComponentFactory) {
        this.interatorComponentFactory = interatorComponentFactory;
    }

    public List<Component> getRepeatedComponents() {
        return this.repeatedComponents;
    }

    public void setRepeatedComponents(List<Component> repeatedComponents) {
        this.repeatedComponents = repeatedComponents;
    }

    public List<IterationContext> getBindedSubcomponents() {
        return this.bindedSubcomponents;
    }

    public String getIterator() {
        return this.iterator;
    }

    public void setIterator(String iterator) {
        this.iterator = iterator;
    }

    public ModelBinding<?> getCollection() {
        return this.collection;
    }

    public void setCollection(ModelBinding<?> collection) {
        this.collection = collection;
    }

    public static class RepeaterIterationContext {
        protected Integer iterationIndex;
        protected String iterationBinding;
        protected String iterationIterator;

        public Integer getIterationIndex() {
            return this.iterationIndex;
        }

        public String getIterationBinding() {
            return this.iterationBinding;
        }

        public String getIterationIterator() {
            return this.iterationIterator;
        }

        public void setIterationIndex(Integer iterationIndex) {
            this.iterationIndex = iterationIndex;
        }

        public void setIterationBinding(String iterationBinding) {
            this.iterationBinding = iterationBinding;
        }

        public void setIterationIterator(String iterationIterator) {
            this.iterationIterator = iterationIterator;
        }

        public RepeaterIterationContext(Integer iterationIndex, String iterationBinding, String iterationIterator) {
            this.iterationIndex = iterationIndex;
            this.iterationBinding = iterationBinding;
            this.iterationIterator = iterationIterator;
        }
    }
}

