/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.TablePaged;

@Control(parents={TablePaged.class, ColumnPaged.class})
public class ColumnPaged
extends Column {
    private boolean sortable = false;
    @JsonIgnore
    @DocumentedComponentAttribute(value="Property name passed in the Pageable object to be interpreted in a data source (eg. DAO)")
    @XMLProperty
    @DesignerXMLProperty(commonUse=true)
    private String sortBy;

    public ColumnPaged(Form form) {
        super(form);
    }

    @Override
    public void init() {
        super.init();
        this.sortable = !StringUtils.isNullOrEmpty((String)this.sortBy) && !this.isSubColumnsExists();
    }

    @Override
    public ElementChanges updateView() {
        boolean sortable;
        ElementChanges elementChanges = super.updateView();
        boolean bl = sortable = this.sortBy != null && !this.sortBy.isEmpty();
        if (!this.areValuesTheSame(this.sortable, sortable)) {
            this.refreshView();
            this.sortable = sortable;
            elementChanges.addChange("sortable", (Object)this.sortable);
        }
        return elementChanges;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }
}

