/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.BaseInputListField;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@TemplateControl(tagName="fh-select-one-menu")
@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, documentationExample=true, value="Component responsible for displaying list of values, with possibility of selecting only one value.", icon="fa fa-caret-square-down")
@DesignerControl(defaultWidth=3)
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Group.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
public class SelectOneMenu
extends BaseInputListField {
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="Determines if selected value that has been removed from values collection should still be present in control.")
    @DesignerXMLProperty(priority=90, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    private boolean keepRemovedValue;
    @XMLProperty
    @DocumentedComponentAttribute(value="Determines empty value text displayed on list of options.")
    @DesignerXMLProperty(priority=60, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    private String emptyLabelText;

    public SelectOneMenu(Form form) {
        super(form);
    }

    @Override
    public SelectOneMenu createNewSameComponent() {
        return new SelectOneMenu(this.getForm());
    }

    public String getModelBindingText() {
        return this.getModelBinding() == null ? "" : this.getModelBinding().getBindingExpression();
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, BaseInputField baseClone) {
        super.doCopy(table, iteratorReplacements, baseClone);
        SelectOneMenu clone = (SelectOneMenu)baseClone;
        clone.setKeepRemovedValue(this.isKeepRemovedValue());
    }

    @Override
    protected Object getChosenObjectAndSetIndex(String newValue) {
        int n = this.newIndex = !StringUtils.isNullOrEmpty((String)newValue) ? Integer.parseInt(newValue) : -1;
        if (this.newIndex == -1) {
            return null;
        }
        Object value = this.presentedValues.get(this.newIndex);
        if (value == null || this.newIndex == 0 && value.equals(this.emptyLabelText)) {
            return null;
        }
        return this.newIndex >= 0 ? value : null;
    }

    @Override
    protected List<?> calculateBindingValues(List<?> value) {
        Object removedValue;
        BindingResult bindingResult;
        LinkedList values = new LinkedList(value);
        if (this.isEmptyLabel()) {
            values.add(0, this.emptyLabelText);
        }
        if (this.isKeepRemovedValue() && (bindingResult = this.getModelBinding().getBindingResult()) != null && !values.contains(removedValue = bindingResult.getValue()) && removedValue != null) {
            values.add(removedValue);
        }
        return values;
    }

    @Override
    protected String convertToRaw(BindingResult<?> bindingResult) {
        Object value;
        Object object = value = bindingResult == null ? null : bindingResult.getValue();
        if (value == null) {
            return "";
        }
        return this.convertMainValueToString(value, this.getOptionalFormatter());
    }

    public boolean isKeepRemovedValue() {
        return this.keepRemovedValue;
    }

    public void setKeepRemovedValue(boolean keepRemovedValue) {
        this.keepRemovedValue = keepRemovedValue;
    }

    public String getEmptyLabelText() {
        return this.emptyLabelText;
    }

    public void setEmptyLabelText(String emptyLabelText) {
        this.emptyLabelText = emptyLabelText;
    }
}

