/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.events.IEventSource;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TableCell;
import pl.fhframework.model.forms.table.LowLevelRowMetadata;

@TemplateControl(tagName="fh-table-row")
public class TableRow {
    @JsonIgnore
    private Table table;
    private List<FormElement> tableCells = new ArrayList<FormElement>();

    public TableRow(Table table, LowLevelRowMetadata lowLevelRowMetadata) {
        this.table = table;
        for (Column column : table.getColumns()) {
            this.tableCells.addAll(column.createTableCells(lowLevelRowMetadata));
        }
    }

    public void updateFormComponents(Set<ElementChanges> formComponentsChanges) {
        for (FormElement tableCell : this.tableCells) {
            if (tableCell instanceof TableCell) {
                ((TableCell)tableCell).doActionForEverySubcomponent(component -> this.updateFromComponent((FormElement)component, formComponentsChanges));
                continue;
            }
            this.updateFromComponent(tableCell, formComponentsChanges);
        }
    }

    public IEventSource getEventSource(String elementId) {
        IEventSource[] result = new IEventSource[1];
        for (FormElement tableCell : this.tableCells) {
            if (tableCell instanceof TableCell) {
                ((TableCell)tableCell).doActionForEverySubcomponent(component -> {
                    if (component.getId().equals(elementId)) {
                        result[0] = component;
                    }
                });
            } else if (tableCell.getId().equals(elementId)) {
                result[0] = tableCell;
            }
            if (result[0] == null) continue;
            break;
        }
        return result[0];
    }

    private void updateFromComponent(FormElement formElement, Set<ElementChanges> formComponentsChanges) {
        ElementChanges elementChanges = formElement.updateView();
        if (!elementChanges.getChangedAttributes().isEmpty()) {
            formComponentsChanges.add(elementChanges);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableRow other = (TableRow)obj;
        if (this.table == null ? other.table != null : !this.table.equals((Object)other.table)) {
            return false;
        }
        return !(this.tableCells == null ? other.tableCells != null : !this.tableCells.equals(other.tableCells));
    }

    public List<FormElement> getTableCells() {
        return this.tableCells;
    }
}

