/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.SpacerService;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.designer.IDesignerEventListener;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Group.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.ARRANGEMENT, documentationExample=true, value="PanelGroup component responsible for the grouping of sub-elements, only one uncollapsed group will be allowed.", icon="fa fa-caret-down")
public class Accordion
extends GroupingComponent<FormElement>
implements Boundable,
IChangeableByClient,
CompactLayout,
IDesignerEventListener {
    private static final String ATTR_ACTIVE_GROUP = "activeGroup";
    public static final String ATTR_ON_GROUP_CHANGE = "onGroupChange";
    public static final Integer DEFAULT_ACTIVE_GROUP = null;
    public static final String ICON_OPENED = "iconOpened";
    public static final String ICON_CLOSED = "iconClosed";
    private Integer activeGroup = DEFAULT_ACTIVE_GROUP;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, then on clicking on group, that method will be executed. This method fires, when group will be opened.")
    private ActionBinding onGroupChange;
    @JsonIgnore
    @XMLProperty(value="activeGroup")
    @DesignerXMLProperty(allowedTypes={Integer.class})
    @DocumentedComponentAttribute(defaultValue="0", boundable=true, value="Index of uncollapsed tab.")
    private ModelBinding<Integer> activeGroupBinding;
    private String iconOpened;
    @JsonIgnore
    @XMLProperty(value="iconOpened")
    @DocumentedComponentAttribute(boundable=true, value="Icon for panel that is open. Please refer to http://fontawesome.io/icons/ for all available icons.")
    @DesignerXMLProperty(priority=84, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE)
    private ModelBinding<String> iconOpenedBinding;
    private String iconClosed;
    @JsonIgnore
    @XMLProperty(value="iconClosed")
    @DocumentedComponentAttribute(boundable=true, value="Icon for closed panel. Please refer to http://fontawesome.io/icons/ for all available icons.")
    @DesignerXMLProperty(priority=84, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE)
    private ModelBinding<String> iconClosedBinding;

    public Accordion(Form form) {
        super(form);
    }

    public void updateModel(ValueChange valueChange) {
        String newValue = valueChange.getMainValue();
        Integer newActiveGroup = Integer.parseInt(newValue);
        if (!Objects.equals(newActiveGroup, this.activeGroup)) {
            this.activeGroup = newActiveGroup;
        }
        if (this.activeGroupBinding != null) {
            this.updateBindingForValue(newActiveGroup, this.activeGroupBinding, this.activeGroup);
        }
    }

    protected ElementChanges updateView() {
        Integer newActiveGroup;
        Object value;
        BindingResult bindingResult;
        ElementChanges elementChanges = super.updateView();
        if (this.activeGroupBinding != null && (bindingResult = this.activeGroupBinding.getBindingResult()) != null && (value = bindingResult.getValue()) != null && !Objects.equals(newActiveGroup = (Integer)this.convertValue(value, Integer.class), this.activeGroup)) {
            this.refreshView();
            this.activeGroup = newActiveGroup;
            elementChanges.addChange(ATTR_ACTIVE_GROUP, (Object)this.activeGroup);
        }
        if (this.iconOpenedBinding != null) {
            this.iconOpened = this.iconOpenedBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.iconOpened, ICON_OPENED);
        }
        if (this.iconClosedBinding != null) {
            this.iconClosed = this.iconClosedBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.iconClosed, ICON_CLOSED);
        }
        return elementChanges;
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ATTR_ON_GROUP_CHANGE.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onGroupChange);
        }
        return super.getEventHandler(eventData);
    }

    public void onDesignerAddDefaultSubcomponent(SpacerService spacerService) {
        this.addSubcomponent((Component)this.createExamplePanel(this.getSubcomponents().size() + 1, spacerService));
    }

    public void onDesignerBeforeAdding(IGroupingComponent<?> parent, SpacerService spacerService) {
        this.addSubcomponent((Component)this.createExamplePanel(1, spacerService));
        this.addSubcomponent((Component)this.createExamplePanel(2, spacerService));
    }

    private PanelGroup createExamplePanel(int nameSuffix, SpacerService spacerService) {
        PanelGroup panel = new PanelGroup(this.getForm());
        panel.setLabelModelBinding((ModelBinding<String>)new StaticBinding((Object)("Accordion Panel " + nameSuffix)));
        panel.setGroupingParentComponent((IGroupingComponent)this);
        panel.addSubcomponent((Component)panel.createNewRow());
        panel.init();
        return panel;
    }

    public void setOnGroupChange(ActionBinding onGroupChange) {
        this.onGroupChange = onGroupChange;
    }

    public IActionCallbackContext setOnGroupChange(IActionCallback onGroupChange) {
        return CallbackActionBinding.createAndSet((IActionCallback)onGroupChange, this::setOnGroupChange);
    }

    public Integer getActiveGroup() {
        return this.activeGroup;
    }

    public ActionBinding getOnGroupChange() {
        return this.onGroupChange;
    }

    public ModelBinding<Integer> getActiveGroupBinding() {
        return this.activeGroupBinding;
    }

    public void setActiveGroupBinding(ModelBinding<Integer> activeGroupBinding) {
        this.activeGroupBinding = activeGroupBinding;
    }

    public String getIconOpened() {
        return this.iconOpened;
    }

    public ModelBinding<String> getIconOpenedBinding() {
        return this.iconOpenedBinding;
    }

    public void setIconOpenedBinding(ModelBinding<String> iconOpenedBinding) {
        this.iconOpenedBinding = iconOpenedBinding;
    }

    public String getIconClosed() {
        return this.iconClosed;
    }

    public ModelBinding<String> getIconClosedBinding() {
        return this.iconClosedBinding;
    }

    public void setIconClosedBinding(ModelBinding<String> iconClosedBinding) {
        this.iconClosedBinding = iconClosedBinding;
    }
}

