/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.model.chart;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import pl.fhframework.model.forms.model.chart.Axis;
import pl.fhframework.model.forms.model.chart.AxisType;
import pl.fhframework.model.forms.model.chart.ChartModel;
import pl.fhframework.model.forms.model.chart.ChartSeries;
import pl.fhframework.model.forms.model.chart.LinearAxis;

public class CartesianChartModel
extends ChartModel {
    protected Map<AxisType, Axis> axes;
    private List<ChartSeries> series = new LinkedList<ChartSeries>();

    public CartesianChartModel() {
        this.createAxis();
    }

    protected void createAxis() {
        this.axes = new HashMap<AxisType, Axis>();
        this.axes.put(AxisType.X, new LinearAxis());
        this.axes.put(AxisType.Y, new LinearAxis());
    }

    public void clear() {
        this.series.clear();
    }

    public void addSeries(ChartSeries chartSeries) {
        this.series.add(chartSeries);
    }

    public Axis getAxisType(String axisType) {
        return this.axes.get(axisType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CartesianChartModel)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CartesianChartModel that = (CartesianChartModel)o;
        boolean equals = Objects.equals(this.axes, that.axes);
        boolean equals1 = Objects.equals(this.series, that.series);
        return equals && equals1;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.axes, this.series);
    }

    public void setAxes(Map<AxisType, Axis> axes) {
        this.axes = axes;
    }

    public void setSeries(List<ChartSeries> series) {
        this.series = series;
    }

    public Map<AxisType, Axis> getAxes() {
        return this.axes;
    }

    public List<ChartSeries> getSeries() {
        return this.series;
    }
}

