/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.SplitContainer;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Form.class, Repeater.class, Group.class, SplitContainer.class}, invalidParents={Anchor.class, Table.class}, canBeDesigned=false)
@DocumentedComponent(category=DocumentedComponent.Category.OTHERS, documentationExample=true, value="Anchor component is responsible for the scrolling whole page or scorllable container to specific invisiable point.", icon="fa fa-anchor")
public class Anchor
extends FormElement
implements Boundable {
    private static final String SCROLL_ATTR = "scroll";
    private static final String ANIMATE_DURATION_ATTR = "animateDuration";
    @XMLProperty
    private Boolean scrollOnStart;
    private Integer animateDuration = 0;
    private Boolean scroll = false;
    @JsonIgnore
    @XMLProperty(value="scroll")
    @DocumentedComponentAttribute(boundable=true, value="Binding represents value from model of Form, used inside of '{}', like {model}.")
    private ModelBinding<Boolean> scrollBinding;
    @JsonIgnore
    @XMLProperty(value="animateDuration")
    @DocumentedComponentAttribute(boundable=true, value="Binding represents value from model of Form, used inside of '{}', like {model}.")
    private ModelBinding<Integer> animateDurationModelBinding;

    public Anchor(Form form) {
        super(form);
    }

    public void init() {
        BindingResult animateDurationResult;
        BindingResult scrollBidingResult;
        super.init();
        if (this.scrollBinding != null && (scrollBidingResult = this.scrollBinding.getBindingResult()) != null && scrollBidingResult.getValue() != null) {
            this.scroll = (Boolean)this.convertValue(scrollBidingResult.getValue(), Boolean.class);
        }
        if (this.animateDurationModelBinding != null && (animateDurationResult = this.animateDurationModelBinding.getBindingResult()) != null && animateDurationResult.getValue() != null) {
            this.animateDuration = (Integer)this.convertValue(animateDurationResult.getValue(), Integer.class);
        }
    }

    protected ElementChanges updateView() {
        BindingResult scrollBindingResult;
        ElementChanges elementChanges = super.updateView();
        if (this.scrollBinding != null && (scrollBindingResult = this.scrollBinding.getBindingResult()) != null) {
            boolean newScroll = this.scroll;
            Object value = scrollBindingResult.getValue();
            if (value instanceof Boolean) {
                newScroll = (Boolean)value;
            }
            if (!Objects.equals(newScroll, this.scroll)) {
                elementChanges.addChange(SCROLL_ATTR, (Object)newScroll);
                this.scrollBinding.setValue((Object)false);
            }
        }
        return elementChanges;
    }

    public Boolean getScrollOnStart() {
        return this.scrollOnStart;
    }

    public void setScrollOnStart(Boolean scrollOnStart) {
        this.scrollOnStart = scrollOnStart;
    }

    public Integer getAnimateDuration() {
        return this.animateDuration;
    }

    public Boolean getScroll() {
        return this.scroll;
    }

    public ModelBinding<Boolean> getScrollBinding() {
        return this.scrollBinding;
    }

    @JsonIgnore
    public void setScrollBinding(ModelBinding<Boolean> scrollBinding) {
        this.scrollBinding = scrollBinding;
    }

    public ModelBinding<Integer> getAnimateDurationModelBinding() {
        return this.animateDurationModelBinding;
    }

    @JsonIgnore
    public void setAnimateDurationModelBinding(ModelBinding<Integer> animateDurationModelBinding) {
        this.animateDurationModelBinding = animateDurationModelBinding;
    }
}

