/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.ButtonGroup;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.DropdownItem;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.SpacerService;
import pl.fhframework.model.forms.Styleable;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.designer.IDesignerEventListener;

@TemplateControl(tagName="fh-dropdown")
@Control(parents={ButtonGroup.class, PanelGroup.class, Group.class, Tab.class, Row.class, Form.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
@DesignerControl(defaultWidth=2)
@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, documentationExample=true, value="PanelGroup component responsible for the grouping of DropdownItems.", icon="fa fa-caret-square-down")
public class Dropdown
extends GroupingComponent<FormElement>
implements Boundable,
Styleable,
IHasBoundableLabel,
CompactLayout,
IDesignerEventListener {
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_STYLE = "style";
    public static final String DROPDOWN_DEFAULT_LABEL = "Dropdown";
    private String label = "Dropdown";
    private Styleable.Style style = Styleable.Style.PRIMARY;
    @JsonIgnore
    @XMLProperty(value="style")
    @DocumentedComponentAttribute(boundable=true, defaultValue="primary", value="Determines style of a Dropdown. It is possible to select one of six Bootstrap classes: default, primary, success, info, warning, danger or bind it with variable.")
    private ModelBinding styleModelBinding;
    @JsonIgnore
    @XMLProperty(required=true, value="label")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, previewValueProvider=BindingExpressionDesignerPreviewProvider.class)
    @DocumentedComponentAttribute(boundable=true, value="Component label")
    private ModelBinding labelModelBinding;

    public Dropdown(Form form) {
        super(form);
    }

    public void init() {
        BindingResult styleBidingResult;
        super.init();
        if (this.styleModelBinding != null && (styleBidingResult = this.styleModelBinding.getBindingResult()) != null) {
            this.style = Styleable.Style.forValue(this.convertBindingValueToString(styleBidingResult));
        }
        if (this.labelModelBinding != null) {
            BindingResult labelBidingResult = this.labelModelBinding.getBindingResult();
            this.label = labelBidingResult != null ? this.convertBindingValueToString(labelBidingResult) : DROPDOWN_DEFAULT_LABEL;
        }
    }

    protected ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        this.processValue(elementChanges);
        this.processStyleBinding(elementChanges);
        return elementChanges;
    }

    private void processValue(ElementChanges elementChanges) {
        String newLabelValue;
        BindingResult bindingResult;
        if (this.labelModelBinding != null && (bindingResult = this.labelModelBinding.getBindingResult()) != null && !this.areValuesTheSame(newLabelValue = this.convertBindingValueToString(bindingResult), this.label)) {
            this.refreshView();
            this.label = newLabelValue;
            elementChanges.addChange(ATTR_LABEL, (Object)this.label);
        }
    }

    private void processStyleBinding(ElementChanges elementChanges) {
        String newLabelValue;
        BindingResult labelBidingResult;
        if (this.styleModelBinding != null && (labelBidingResult = this.styleModelBinding.getBindingResult()) != null && !this.areValuesTheSame(newLabelValue = this.convertBindingValueToString(labelBidingResult), this.style.toValue())) {
            this.style = Styleable.Style.forValue(newLabelValue);
            elementChanges.addChange(ATTR_STYLE, (Object)this.style);
        }
    }

    public void onDesignerAddDefaultSubcomponent(SpacerService spacerService) {
        this.addSubcomponent((Component)this.createExampleDropdownItem(this.getSubcomponents().size() + 1));
    }

    public void onDesignerBeforeAdding(IGroupingComponent<?> parent, SpacerService spacerService) {
        this.addSubcomponent((Component)this.createExampleDropdownItem(1));
        this.addSubcomponent((Component)this.createExampleDropdownItem(2));
        this.addSubcomponent((Component)this.createExampleDropdownItem(3));
    }

    private DropdownItem createExampleDropdownItem(int nameSuffix) {
        DropdownItem tab = new DropdownItem(this.getForm());
        tab.setModelBindingForValue((ModelBinding)new StaticBinding((Object)("Dropdown item " + nameSuffix)));
        tab.setGroupingParentComponent((IGroupingComponent)this);
        tab.init();
        return tab;
    }

    public String getLabel() {
        return this.label;
    }

    public Styleable.Style getStyle() {
        return this.style;
    }

    public void setStyle(Styleable.Style style) {
        this.style = style;
    }

    public ModelBinding getStyleModelBinding() {
        return this.styleModelBinding;
    }

    @JsonIgnore
    public void setStyleModelBinding(ModelBinding styleModelBinding) {
        this.styleModelBinding = styleModelBinding;
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    @JsonIgnore
    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }
}

