/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhException;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.SpacerService;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.IDesignerEventListener;
import pl.fhframework.model.forms.designer.SizePxDesignerPreviewProvider;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.ARRANGEMENT, documentationExample=true, value="Container component responsible for placing components on a single line with movable column", icon="fa fa-columns")
public class SplitContainer
extends GroupingComponent<FormElement>
implements IDesignerEventListener,
CompactLayout {
    public static final String SIZE_LEFT_ATTR = "sizeLeft";
    public static final String SIZE_RIGHT_ATTR = "sizeRight";
    private String sizeLeft;
    @JsonIgnore
    @XMLProperty(value="sizeLeft")
    @DocumentedComponentAttribute(value="Defines width in percent of the left panel of this SplitContainer")
    @DesignerXMLProperty(previewValueProvider=SizePxDesignerPreviewProvider.class)
    private ModelBinding sizeLeftBinding;
    private String sizeRight;
    @JsonIgnore
    @XMLProperty(value="sizeRight")
    @DocumentedComponentAttribute(value="Defines width in percent of the right panel of this SplitContainer")
    @DesignerXMLProperty(previewValueProvider=SizePxDesignerPreviewProvider.class)
    private ModelBinding sizeRightBinding;

    public SplitContainer(Form form) {
        super(form);
    }

    public void addSubcomponent(FormElement formElement) {
        if (this.getSubcomponents().size() >= 2) {
            String errorMessage = "SplitContainer can't have more than 2 subcomponents!! [id: " + this.getId();
            FhLogger.error((String)errorMessage, (Object[])new Object[0]);
            throw new FhException(errorMessage);
        }
        super.addSubcomponent((Component)formElement);
    }

    public void onDesignerBeforeAdding(IGroupingComponent<?> parent, SpacerService spacerService) {
        this.addSubcomponent(this.createGroup(spacerService));
        this.addSubcomponent(this.createGroup(spacerService));
    }

    protected ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        if (this.sizeLeftBinding != null) {
            this.sizeLeft = this.sizeLeftBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.sizeLeft, SIZE_LEFT_ATTR);
        }
        if (this.sizeRightBinding != null) {
            this.sizeRight = this.sizeRightBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.sizeRight, SIZE_RIGHT_ATTR);
        }
        return elementChanges;
    }

    private FormElement createGroup(SpacerService spacerService) {
        Group group = new Group(this.getForm());
        group.setWidth("md-12");
        group.init();
        group.setGroupingParentComponent((IGroupingComponent)this);
        return group;
    }

    public String getSizeLeft() {
        return this.sizeLeft;
    }

    public ModelBinding getSizeLeftBinding() {
        return this.sizeLeftBinding;
    }

    @JsonIgnore
    public void setSizeLeftBinding(ModelBinding sizeLeftBinding) {
        this.sizeLeftBinding = sizeLeftBinding;
    }

    public String getSizeRight() {
        return this.sizeRight;
    }

    public ModelBinding getSizeRightBinding() {
        return this.sizeRightBinding;
    }

    @JsonIgnore
    public void setSizeRightBinding(ModelBinding sizeRightBinding) {
        this.sizeRightBinding = sizeRightBinding;
    }
}

