/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.OverridenPropertyAnnotations;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.IndexedModelBinding;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.core.FhBindingException;
import pl.fhframework.core.FhException;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.core.util.CollectionsUtils;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.ColumnLazy;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.PageModel;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TablePaged;
import pl.fhframework.model.forms.utils.LanguageResolver;

@Control(parents={GroupingComponent.class}, invalidParents={Table.class, TablePaged.class}, canBeDesigned=true)
@OverridenPropertyAnnotations(property="collection", designerXmlProperty={@DesignerXMLProperty(allowedTypes={Page.class, PageModel.class}, commonUse=true, bindingOnly=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, priority=15)})
@DocumentedComponent(category=DocumentedComponent.Category.TABLE_AND_TREE, documentationExample=true, value="Table that allows to arrange data like text, images, links, other tables, etc. into rows and columns of cells inside of page. Lazyloads its data.", icon="fa fa-table")
public class TableLazy
extends Table {
    private static final String SORT_BY_ATTRIBUTE = "sortBy";
    private static final String DIRECTION_ATTRIBUTE = "direction";
    private static final String LOAD_MORE_ATTRIBIUTE = "loadMorePage";
    private static final String LOAD_All_ATTRIBIUTE = "loadAllPages";
    private PageRequest loadable = null;
    private int totalPages;
    private long totalRows;
    private int pageNumber;
    @XMLProperty(defaultValue="9999")
    @DocumentedComponentAttribute(value="Amount of records displayed on first show")
    private Integer startSize;
    @JsonIgnore
    private Page loadMorePage;
    @XMLProperty(defaultValue="false")
    @DocumentedComponentAttribute(value="Load all data automaticly")
    private Boolean loadAllPages;
    @JsonIgnore
    private PageModel pageModel;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(defaultValue="-")
    @DocumentedComponentAttribute(defaultValue="-", value="Method executed when loading more content")
    private ActionBinding onLoadMore;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(defaultValue="-")
    @DocumentedComponentAttribute(defaultValue="-", value="If the table page sorting is changed that method will be executed")
    private ActionBinding onSortChange;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty
    @DocumentedComponentAttribute(value="Property name by default passed in the Pageable object to be interpreted in a data source (eg. DAO)")
    private String defaultSortBy;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(defaultValue="true")
    @DocumentedComponentAttribute(value="If defaultSortBy is set this property decides if default order is ascending ", defaultValue="true")
    private boolean defaultSortByAsc = true;
    private String language;
    private static final int PAGE_START = 0;
    private static final String ON_LOAD_MORE = "onLoadMore";
    private static final String ON_SORT_CHANGE = "onSortChange";
    private static final String DISPLAYED_TOTAL_PAGES = "totalPages";
    private static final String DISPLAYED_TOTAL_ROWS = "totalRows";
    private static final String CURRENT_PAGE_NUMBER = "pageNumber";

    public TableLazy(Form form) {
        super(form);
    }

    @Override
    public void init() {
        super.init();
        if (this.startSize == null) {
            this.startSize = 9999;
        }
        if (this.loadAllPages == null) {
            this.loadAllPages = false;
        }
        this.pageNumber = 0;
        this.changePageOrSize(this.pageNumber, this.startSize);
    }

    @Override
    public int getRowNumberOffset() {
        return this.startSize * this.pageNumber;
    }

    @Override
    protected Collection extractCollection(IndexedModelBinding collectionBinding, int[] parentIteratorIndices, boolean isMainLevel) {
        if (isMainLevel) {
            Object bindingResultObj = collectionBinding.getValue(parentIteratorIndices);
            if (bindingResultObj != null) {
                return this.extractMainCollection(collectionBinding, bindingResultObj);
            }
            return null;
        }
        return super.extractCollection(collectionBinding, parentIteratorIndices, isMainLevel);
    }

    private Collection extractMainCollection(IndexedModelBinding collectionBinding, Object bindingResultObj) {
        if (bindingResultObj instanceof PageModel) {
            PageModel pageModel;
            this.pageModel = pageModel = (PageModel)bindingResultObj;
            if (this.pageModel.isResetNeeded()) {
                this.changePageOrSize(0, this.startSize);
            }
            if (this.pageModel.isRefreshNeeded()) {
                this.pageModel.doRefresh((Pageable)this.loadable);
            }
            this.loadMorePage = pageModel.getPage();
            return this.extractMainCollection();
        }
        if (bindingResultObj instanceof Page) {
            this.loadMorePage = (Page)bindingResultObj;
            return this.extractMainCollection();
        }
        throw new FhException("Not instance of PageModel: " + collectionBinding.getBindingExpression());
    }

    private Collection extractMainCollection() {
        this.mainCollection = this.loadMorePage.getContent();
        return this.mainCollection;
    }

    @Override
    public void updateModel(ValueChange valueChange) {
        String newTextValue;
        if (valueChange.hasMainValueChanged() && this.containsNumeric(valueChange.getMainValue()) && this.getSelectedElementBinding() != null && (newTextValue = valueChange.getMainValue()) != null) {
            Object newSelectedElement;
            newTextValue = newTextValue.substring(1, newTextValue.length() - 1);
            this.selectedRowsNumbers = Arrays.stream(newTextValue.split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
            Collection<Object> bindedObjectsList = this.getBindedObjectsList();
            if (this.isMultiselect()) {
                newSelectedElement = this.getSelectedElementsBasedOnRowsNumbers(bindedObjectsList, this.selectedRowsNumbers);
                if (this.getSelectedElementBinding().getBindingResult() != null) {
                    Collection muliselectCol = (Collection)this.getSelectedElementBinding().getBindingResult().getValue();
                    if (muliselectCol != null) {
                        muliselectCol.removeAll(bindedObjectsList);
                        muliselectCol.addAll((Collection)newSelectedElement);
                    } else {
                        this.getSelectedElementBinding().setValue(newSelectedElement);
                    }
                } else {
                    this.getSelectedElementBinding().setValue(newSelectedElement);
                }
            } else {
                newSelectedElement = this.selectedRowsNumbers[0] > -1 && bindedObjectsList.size() > this.selectedRowsNumbers[0] ? CollectionsUtils.get(bindedObjectsList, (int)this.selectedRowsNumbers[0]) : null;
                this.getSelectedElementBinding().setValue(newSelectedElement);
            }
        }
        boolean refreshNeeded = false;
        if (valueChange.hasAttributeChanged(LOAD_MORE_ATTRIBIUTE)) {
            int pageNumber = valueChange.getIntAttribute(LOAD_MORE_ATTRIBIUTE);
            this.changePageOrSize(0, this.startSize * (pageNumber + 1));
            refreshNeeded = true;
        }
        if (valueChange.hasAttributeChanged(LOAD_All_ATTRIBIUTE)) {
            this.setLoadAllPages(valueChange.getBooleanAttribute(LOAD_MORE_ATTRIBIUTE));
            this.changePageOrSize(0, this.loadable.getPageSize() * this.loadMorePage.getTotalPages());
            refreshNeeded = true;
        }
        if (valueChange.hasAttributeChanged(SORT_BY_ATTRIBUTE)) {
            String sortBy = valueChange.getStringAttribute(SORT_BY_ATTRIBUTE);
            String directionString = valueChange.getStringAttribute(DIRECTION_ATTRIBUTE);
            Sort.Direction direction = directionString != null ? Sort.Direction.valueOf((String)directionString) : null;
            ColumnLazy column = (ColumnLazy)this.getSortingColumn(sortBy, this.getColumns());
            this.loadable = PageRequest.of((int)this.pageNumber, (int)this.loadable.getPageSize(), (Sort.Direction)direction, (String[])new String[]{column.getSortBy()});
            refreshNeeded = true;
        }
        if (refreshNeeded && this.pageModel != null) {
            this.pageModel.refreshNeeded();
        }
    }

    public boolean containsNumeric(String text) {
        int endIdx;
        if (text == null) {
            return false;
        }
        int startIdx = text.indexOf("[");
        if (startIdx > (endIdx = text.indexOf("]"))) {
            FhLogger.error((String)"Could not retrieve numeric value from passed String: {}", (Object[])new Object[]{text});
            return false;
        }
        return text != null && text.matches(".*\\d.*");
    }

    @Override
    public ElementChanges updateView() {
        ElementChanges elementChange = super.updateView();
        if (this.loadMorePage != null && this.totalPages != this.loadMorePage.getTotalPages()) {
            this.totalPages = this.loadMorePage.getTotalPages();
            elementChange.addChange(DISPLAYED_TOTAL_PAGES, (Object)this.totalPages);
        }
        if (this.loadMorePage != null && this.totalRows != this.loadMorePage.getTotalElements()) {
            this.totalRows = this.loadMorePage.getTotalElements();
            elementChange.addChange(DISPLAYED_TOTAL_ROWS, (Object)this.totalRows);
        }
        if (this.loadMorePage != null && this.pageNumber != this.loadMorePage.getNumber()) {
            this.pageNumber = this.loadMorePage.getNumber();
            elementChange.addChange(CURRENT_PAGE_NUMBER, (Object)this.pageNumber);
        }
        this.language = LanguageResolver.languageChanges(this.getForm().getAbstractUseCase().getUserSession(), this.language, elementChange);
        return elementChange;
    }

    @Override
    protected Collection<Object> getBindedObjectsList() {
        if (this.getCollection() == null) {
            throw new FhBindingException("Table '" + this.getId() + "' has not binding for 'collection'!");
        }
        Object list = this.getCollection().getBindingResult().getValue();
        if (list != null) {
            if (list instanceof Collection) {
                return (Collection)list;
            }
            if (list instanceof Page && ((Page)list).getContent() != null) {
                return ((Page)list).getContent();
            }
            if (list instanceof PageModel && ((PageModel)list).getPage() != null && ((PageModel)list).getPage().getContent() != null) {
                return ((PageModel)list).getPage().getContent();
            }
            if (!(list instanceof Page) && !(list instanceof PageModel)) {
                throw new FhBindingException("Binded for table '" + this.getId() + "' class object '" + list.getClass().getSimpleName() + "' is not a Collection nor Page!");
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        FhLogger.trace(((Object)((Object)this)).getClass(), logger -> logger.log("TablePaged will handle {}", new Object[]{this.selectedRowsNumbers[0]}));
        if (ON_LOAD_MORE.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onLoadMore);
        }
        if (ON_SORT_CHANGE.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onSortChange);
        }
        return super.getEventHandler(eventData);
    }

    public void setOnLoadMore(ActionBinding onLoadMore) {
        this.onLoadMore = onLoadMore;
    }

    public IActionCallbackContext setOnLoadMore(IActionCallback onLoadMore) {
        return CallbackActionBinding.createAndSet((IActionCallback)onLoadMore, this::setOnLoadMore);
    }

    public void setOnSortChange(ActionBinding onSortChange) {
        this.onSortChange = onSortChange;
    }

    public IActionCallbackContext setOnSortChange(IActionCallback onSortChange) {
        return CallbackActionBinding.createAndSet((IActionCallback)onSortChange, this::setOnSortChange);
    }

    @Override
    protected ColumnLazy createExampleColumn(int nameSuffix) {
        ColumnLazy column = new ColumnLazy(this.getForm());
        column.setLabelModelBinding((ModelBinding)new StaticBinding((Object)("Column " + nameSuffix)));
        column.setTable(this);
        column.setGroupingParentComponent((IGroupingComponent)this);
        column.init();
        return column;
    }

    private void changePageOrSize(int newPageNumber, int newPageSize) {
        Sort.Order order = this.getSortingOrder();
        this.loadable = order != null ? PageRequest.of((int)newPageNumber, (int)newPageSize, (Sort.Direction)order.getDirection(), (String[])new String[]{order.getProperty()}) : PageRequest.of((int)newPageNumber, (int)newPageSize);
    }

    private Sort.Order getSortingOrder() {
        if (this.loadable != null && this.loadable.getSort() != null && !this.loadable.getSort().isEmpty()) {
            Iterator orderIterator = this.loadable.getSort().iterator();
            return (Sort.Order)orderIterator.next();
        }
        if (this.defaultSortBy != null) {
            return new Sort.Order(this.defaultSortByAsc ? Sort.Direction.ASC : Sort.Direction.DESC, this.defaultSortBy);
        }
        return null;
    }

    private Column getSortingColumn(String sortBy, List<? extends Component> components) {
        for (Component component : components) {
            Column nestedColumn;
            if (!(component instanceof Column)) continue;
            Column column = (Column)component;
            if (sortBy.equals(column.getId())) {
                return column;
            }
            if (column.getSubcomponents() == null || (nestedColumn = this.getSortingColumn(sortBy, column.getSubcomponents())) == null) continue;
            return nestedColumn;
        }
        return null;
    }

    public PageRequest getLoadable() {
        return this.loadable;
    }

    public void setLoadable(PageRequest loadable) {
        this.loadable = loadable;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public Integer getStartSize() {
        return this.startSize;
    }

    public void setStartSize(Integer startSize) {
        this.startSize = startSize;
    }

    public Boolean getLoadAllPages() {
        return this.loadAllPages;
    }

    public void setLoadAllPages(Boolean loadAllPages) {
        this.loadAllPages = loadAllPages;
    }

    public ActionBinding getOnLoadMore() {
        return this.onLoadMore;
    }

    public ActionBinding getOnSortChange() {
        return this.onSortChange;
    }

    public String getDefaultSortBy() {
        return this.defaultSortBy;
    }

    public void setDefaultSortBy(String defaultSortBy) {
        this.defaultSortBy = defaultSortBy;
    }

    public boolean isDefaultSortByAsc() {
        return this.defaultSortByAsc;
    }

    public void setDefaultSortByAsc(boolean defaultSortByAsc) {
        this.defaultSortByAsc = defaultSortByAsc;
    }

    public String getLanguage() {
        return this.language;
    }
}

