/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.attributes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.attributes.Attribute;
import pl.fhframework.model.forms.attributes.BoundableAttribute;
import pl.fhframework.model.forms.attributes.FloatingOnlyAttribute;

@DocumentedComponentAttribute(value="Defines state of floating group", type=Enum.class, defaultValue="PINNED_MINIMIZED", boundable=true)
@XMLProperty(value="floatingState")
public class FloatingGroupStateAttribute
extends Attribute<FloatingState>
implements BoundableAttribute {
    public static final String STATE_ATTR = "floatingState";
    private FloatingState value;
    @JsonIgnore
    private ModelBinding modelBinding;
    private FloatingOnlyAttribute floatingOnlyAttribute;

    public FloatingGroupStateAttribute(Form form, Component component, ModelBinding<FloatingState> modelBinding, FloatingOnlyAttribute floatingOnlyAttribute) {
        block6: {
            super(form, component);
            if (modelBinding != null) {
                BindingResult bindingResult = modelBinding.getBindingResult();
                if (bindingResult != null) {
                    try {
                        if (bindingResult.getValue() instanceof String) {
                            this.value = FloatingState.valueOf((String)bindingResult.getValue());
                            break block6;
                        }
                        this.value = (FloatingState)((Object)bindingResult.getValue());
                    }
                    catch (IllegalArgumentException e) {
                        FhLogger.warn((String)("Did not find matching value: \"" + bindingResult.getValue() + "\" for floatingState enum."), (Object[])new Object[0]);
                    }
                }
            } else {
                this.value = this.getDefaultValue();
            }
        }
        this.modelBinding = modelBinding;
        this.floatingOnlyAttribute = floatingOnlyAttribute;
        this.normalizeValue();
    }

    @Override
    public FloatingState getValue() {
        return this.value;
    }

    @Override
    public void setValue(FloatingState value) {
        this.value = value;
    }

    @Override
    public String getXmlValue() {
        return STATE_ATTR;
    }

    @Override
    public FloatingState getDefaultValue() {
        return FloatingState.PINNED_MINIMIZED;
    }

    @Override
    public ElementChanges updateView(Component component, ElementChanges elementChanges) {
        FloatingState newValue;
        BindingResult bindingResult;
        if (this.modelBinding != null && (bindingResult = this.modelBinding.getBindingResult()) != null && !Objects.equals((Object)(newValue = (FloatingState)((Object)component.convertValue(bindingResult.getValue(), FloatingState.class))), (Object)this.value)) {
            this.value = newValue;
            this.normalizeValue();
            elementChanges.addChange(this.getXmlValue(), (Object)this.value);
        }
        return elementChanges;
    }

    private void normalizeValue() {
        if (Boolean.TRUE.equals(this.floatingOnlyAttribute.getValue())) {
            if (FloatingState.PINNED_MINIMIZED == this.value) {
                this.value = FloatingState.UNPINNED_MINIMIZED;
            } else if (FloatingState.PINNED_MAXIMIZED == this.value) {
                this.value = FloatingState.UNPINNED_MAXIMIZED;
            }
        }
    }

    @Override
    public void updateModel(Component component, ValueChange valueChange) {
        String state = valueChange.getStringAttribute(this.getXmlValue());
        FloatingState newValue = (FloatingState)((Object)component.convertValue((Object)state, FloatingState.class));
        if (!Objects.equals((Object)newValue, (Object)this.value)) {
            this.updateBindingForValue((Object)newValue, this.modelBinding, this.modelBinding.getBindingExpression());
            this.value = newValue;
        }
    }

    @Override
    public ModelBinding getModelBinding() {
        return this.modelBinding;
    }

    @Override
    @JsonIgnore
    public void setModelBinding(ModelBinding modelBinding) {
        this.modelBinding = modelBinding;
    }

    public static enum FloatingState {
        PINNED_MINIMIZED(true, false),
        PINNED_MAXIMIZED(true, true),
        UNPINNED_MINIMIZED(false, false),
        UNPINNED_MAXIMIZED(false, true);

        private boolean pinned;
        private boolean fullScreen;

        private FloatingState(boolean pinned, boolean fullScreen) {
            this.pinned = pinned;
            this.fullScreen = fullScreen;
        }

        public boolean isPinned() {
            return this.pinned;
        }

        public void setPinned(boolean pinned) {
            this.pinned = pinned;
        }

        public boolean isFullScreen() {
            return this.fullScreen;
        }

        public void setFullScreen(boolean fullScreen) {
            this.fullScreen = fullScreen;
        }

        public FloatingState toPinned() {
            if (this.isFullScreen()) {
                return PINNED_MAXIMIZED;
            }
            return PINNED_MINIMIZED;
        }

        public FloatingState toFloating() {
            if (this.isFullScreen()) {
                return UNPINNED_MAXIMIZED;
            }
            return UNPINNED_MINIMIZED;
        }
    }
}

